/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.DataException;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.VarCharColumn;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class CharColumn
extends Column {
    protected String[] values;
    int columnType = 10;
    protected int maxWidth;
    protected int maxOctetLength;
    protected int maxWidthSpecified = 0;

    CharColumn() {
        this.values = new String[initialBatchCapacity];
        this.maxWidth = 0;
    }

    CharColumn(int n) {
        this.values = new String[initialBatchCapacity];
        this.maxWidth = n;
    }

    CharColumn(int n, int n2, int n3) {
        this.columnType = n3;
        this.values = new String[initialBatchCapacity];
        this.maxWidth = n;
        this.maxOctetLength = n2;
    }

    CharColumn(String string, String[] stringArray) {
        super(string);
        this.values = stringArray;
        this.maxWidth = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.maxWidth >= this.values[i].length()) continue;
            this.maxWidth = this.values[i].length();
        }
    }

    int getPrecision() throws SQLException {
        return this.maxWidth;
    }

    public void setMaxColumnSize(int n) {
        this.maxWidthSpecified = n;
    }

    public int getMaxColumnSize() {
        return this.maxWidthSpecified;
    }

    void setPrecision(int n) {
        this.maxWidth = n;
    }

    void setScale(int n) throws SQLException {
        throw new SQLException("Not implemented for CharColumn - setScale()");
    }

    String getClassName() {
        return "java.lang.String";
    }

    int getDisplaySize(EXAConnection eXAConnection) throws SQLException {
        return this.getPrecision();
    }

    int getOctetLength() {
        return this.maxOctetLength;
    }

    int getType() {
        switch (this.columnType) {
            case 17: {
                return -104;
            }
            case 16: {
                return -103;
            }
        }
        return 1;
    }

    String getTypeName() {
        switch (this.columnType) {
            case 17: {
                return "INTERVAL DAY TO SECOND";
            }
            case 16: {
                return "INTERVAL YEAR TO MONTH";
            }
        }
        return "CHAR";
    }

    Object getObject(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getObject: " + Translator.Accessed_null_value());
        }
        return this.values[n];
    }

    String getString(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getString: " + Translator.Accessed_null_value());
        }
        return this.values[n];
    }

    Time getTime(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getTime: " + Translator.Accessed_null_value());
        }
        return Time.valueOf(this.values[n]);
    }

    boolean getBoolean(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getBoolean: " + Translator.Accessed_null_value());
        }
        if (this.values[n].trim().equalsIgnoreCase("1")) {
            return true;
        }
        if (this.values[n].trim().equalsIgnoreCase("0")) {
            return false;
        }
        if (this.values[n].trim().equalsIgnoreCase("Y")) {
            return true;
        }
        if (this.values[n].trim().equalsIgnoreCase("N")) {
            return false;
        }
        if (this.values[n].trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (this.values[n].trim().equalsIgnoreCase("false")) {
            return false;
        }
        throw new SQLException("CharColumn::getBoolean: " + Translator.Conversion_not_possible());
    }

    byte getByte(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getByte: " + Translator.Accessed_null_value());
        }
        return Byte.parseByte(this.values[n]);
    }

    double getDouble(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getDouble: " + Translator.Accessed_null_value());
        }
        return Double.parseDouble(this.values[n]);
    }

    float getFloat(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getFloat: " + Translator.Accessed_null_value());
        }
        return Float.parseFloat(this.values[n]);
    }

    int getInt(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getInt: " + Translator.Accessed_null_value());
        }
        return Integer.parseInt(this.values[n]);
    }

    long getLong(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getLong: " + Translator.Accessed_null_value());
        }
        return Long.parseLong(this.values[n]);
    }

    short getShort(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getShort: " + Translator.Accessed_null_value());
        }
        return Short.parseShort(this.values[n]);
    }

    Timestamp getTimestamp(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getTimestamp: " + Translator.Accessed_null_value());
        }
        return Timestamp.valueOf(this.values[n]);
    }

    Date getDate(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getDate: " + Translator.Accessed_null_value());
        }
        return Date.valueOf(this.values[n]);
    }

    BigDecimal getBigDecimal(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException("CharColumn::getBigDecimal: " + Translator.Accessed_null_value());
        }
        return new BigDecimal(this.values[n]);
    }

    void resize(int n) {
        int n2;
        String[] stringArray = new String[n];
        boolean[] blArray = new boolean[n];
        int n3 = this.values.length;
        if (n3 > n) {
            n3 = n;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = this.values[n2];
            blArray[n2] = this.validMask[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            blArray[n2] = false;
        }
        this.values = stringArray;
        this.validMask = blArray;
    }

    static Column from_jdbc_type(EXAInputStream eXAInputStream, EXAConnection eXAConnection, int n) throws IOException {
        byte by = eXAInputStream.readByte();
        int n2 = eXAInputStream.readInt();
        int n3 = eXAInputStream.readInt();
        if (1 == (by & 1)) {
            return new VarCharColumn(n2, n3);
        }
        return new CharColumn(n2, n3, n);
    }

    void setBigDecimal(int n, BigDecimal bigDecimal) {
        this.setString(n, bigDecimal.toString());
    }

    void setBoolean(int n, boolean bl) {
        this.setString(n, bl ? "TRUE" : "FALSE");
    }

    void setByte(int n, byte by) {
        this.setString(n, String.valueOf(by));
    }

    void setDate(int n, Date date) {
        this.setString(n, date.toString());
    }

    void setDouble(int n, double d) {
        this.setString(n, String.valueOf(d));
    }

    void setFloat(int n, float f) {
        this.setString(n, String.valueOf(f));
    }

    void setInt(int n, int n2) {
        this.setString(n, String.valueOf(n2));
    }

    void setLong(int n, long l) {
        this.setString(n, String.valueOf(l));
    }

    void setObject(int n, Object object) {
        this.setString(n, object.toString());
    }

    void setShort(int n, short s) {
        this.setString(n, String.valueOf(s));
    }

    void setString(int n, String string) {
        this.validMask[n] = true;
        if (string.length() > this.maxWidth) {
            this.maxWidth = string.length();
        }
        this.values[n] = string;
    }

    void setTime(int n, Time time) {
        this.setString(n, time.toString());
    }

    void setTimestamp(int n, Timestamp timestamp) {
        this.setString(n, timestamp.toString());
    }

    void setNull(int n) {
        this.validMask[n] = false;
        this.values[n] = null;
    }

    void value_to_jdbc(EXAOutputStream eXAOutputStream, int n) throws SQLException, IOException {
        if (this.validMask[n]) {
            eXAOutputStream.writeByte((byte)1);
            String string = this.values[n];
            if (string.length() > this.maxWidth) {
                throw new DataException(Translator.string_data_right_truncation() + ". StringLength " + string.length() + " > MaxLength " + this.maxWidth + ". The string starts with: " + string.substring(0, 200 >= string.length() ? string.length() - 1 : 200), new String("001"));
            }
            byte[] byArray = string.getBytes(eXAOutputStream.getEncoding());
            eXAOutputStream.writeInt(byArray.length);
            eXAOutputStream.write(byArray);
        } else {
            eXAOutputStream.writeByte((byte)0);
        }
    }

    void value_from_jdbc(EXAInputStream eXAInputStream, int n) throws SQLException, IOException {
        if (eXAInputStream.nextIsNull()) {
            this.validMask[n] = false;
        } else {
            this.values[n] = eXAInputStream.readString();
            this.validMask[n] = true;
        }
    }

    int getEXAType() {
        return this.columnType;
    }
}

