/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.ui;

import com.dbeaver.ee.qmdb.model.QMDBModel;
import com.dbeaver.ee.qmdb.server.EmbeddedDatabase;
import com.dbeaver.ee.qmdb.ui.QMDBUIMessages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.ContentUtils;

public class QMDBPreferencePage
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "com.dbeaver.ee.qmdb.persistence";
    private IAdaptable element;

    protected Control createContents(Composite parent) {
        final EmbeddedDatabase database = QMDBModel.getInstance().getEmbeddedDatabase();
        Group composite = UIUtils.createControlGroup((Composite)parent, (String)QMDBUIMessages.preference_page_group_database, (int)2, (int)768, (int)0);
        UIUtils.createLabelText((Composite)composite, (String)QMDBUIMessages.preference_page_label_text_database_path, (String)database.getDatabasePath().getAbsolutePath(), (int)2056, (Object)new GridData(768));
        Composite buttonsGroup = UIUtils.createComposite((Composite)composite, (int)1);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        UIUtils.createDialogButton((Composite)buttonsGroup, (String)QMDBUIMessages.preference_page_push_button_backup_database, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QMDBPreferencePage.this.backupDatabase(database);
            }
        });
        UIUtils.createDialogButton((Composite)buttonsGroup, (String)QMDBUIMessages.preference_page_push_button_repair_database, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QMDBPreferencePage.this.repairDatabase(database);
            }
        });
        UIUtils.createDialogButton((Composite)buttonsGroup, (String)QMDBUIMessages.preference_page_push_button_truncate_database, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QMDBPreferencePage.this.truncateDatabase(database);
            }
        });
        UIUtils.createInfoLabel((Composite)parent, (String)QMDBUIMessages.preference_page_info_label_h2_embedded_database);
        return composite;
    }

    private void backupDatabase(EmbeddedDatabase database) {
        File file = DialogUtils.selectFileForSave((Shell)this.getShell(), (String)"QMDB-backup.zip");
        if (file != null) {
            try {
                UIUtils.runInProgressDialog(monitor -> {
                    monitor.beginTask("Backup QMDB database", 1);
                    try {
                        monitor.subTask(file.getAbsolutePath());
                        database.backupDatabase(file);
                        UIUtils.showMessageBox(null, (String)"Backup", (String)"Backup finished", (int)2);
                    }
                    catch (DBException e1) {
                        throw new InvocationTargetException(e1);
                    }
                    monitor.done();
                });
            }
            catch (InvocationTargetException e1) {
                DBWorkbench.getPlatformUI().showError("QMDB backup", "Error making QMDB backup", (Throwable)e1);
            }
        }
    }

    private void repairDatabase(EmbeddedDatabase database) {
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Repair database", (String)"Database repair may corrupt it. You may loose all query history. Do it after database backup.\nAre you sure you want to proceed with database repair?")) {
            return;
        }
        try {
            UIUtils.runInProgressDialog(monitor -> {
                monitor.beginTask("Repair QMDB database", 6);
                try {
                    monitor.subTask("Stop QMDB");
                    database.stop();
                    monitor.worked(1);
                    monitor.subTask("Dump SQL into " + database.getDatabasePath().getAbsolutePath());
                    File sqlDumpFile = database.dumpDatabaseToSQL();
                    monitor.worked(1);
                    monitor.subTask("Delete old QMDB files");
                    database.deleteDatabaseFiles();
                    monitor.worked(1);
                    monitor.subTask("Restore from backup " + sqlDumpFile.getAbsolutePath());
                    database.restoreFromSQL(sqlDumpFile);
                    monitor.worked(1);
                    monitor.subTask("Start QMDB");
                    database.start();
                    monitor.worked(1);
                    monitor.subTask("Delete backup file");
                    sqlDumpFile.delete();
                    monitor.worked(1);
                    UIUtils.showMessageBox(null, (String)"Repair", (String)"Repair finished", (int)2);
                }
                catch (DBException e1) {
                    throw new InvocationTargetException(e1);
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e1) {
            DBWorkbench.getPlatformUI().showError("QMDB repair", "Error repairing QMDB database", (Throwable)e1);
        }
    }

    private void truncateDatabase(EmbeddedDatabase database) {
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Truncate database", (String)"Database truncate will erase all historic SQL queries.\nAre you sure you want to proceed with truncate?")) {
            return;
        }
        try {
            UIUtils.runInProgressDialog(monitor -> {
                File backupFile = new File(database.getDatabasePath().getParentFile(), "qmdb-backup-auto.zip");
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                monitor.beginTask("Truncate QMDB database", 6);
                try {
                    monitor.subTask("Make backup to " + backupFile.getAbsolutePath());
                    database.backupDatabase(backupFile);
                    monitor.worked(1);
                    monitor.subTask("Stop QMDB");
                    database.stop();
                    monitor.worked(1);
                    monitor.subTask("Delete old QMDB files");
                    ContentUtils.deleteFileRecursive((File)database.getDatabasePath());
                    monitor.worked(1);
                    monitor.subTask("Restore from backup " + backupFile.getAbsolutePath());
                    database.restoreDatabase(backupFile);
                    monitor.worked(1);
                    monitor.subTask("Start QMDB");
                    database.start();
                    monitor.worked(1);
                    monitor.subTask("Delete backup file");
                    backupFile.delete();
                    monitor.worked(1);
                    UIUtils.showMessageBox(null, (String)"Truncate", (String)"Truncate finished", (int)2);
                }
                catch (DBException e1) {
                    throw new InvocationTargetException(e1);
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e1) {
            DBWorkbench.getPlatformUI().showError("QMDB truncate", "Error truncating QMDB database", (Throwable)e1);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        return true;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }
}

