/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.dbf;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.relique.io.DataReader;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.MinimumMemoryMap;
import org.relique.jdbc.dbf.DbfClassNotFoundException;

public class DbfReader
extends DataReader {
    private Object table = null;
    private List fields;
    private Integer recordCount;
    private Object record;
    private int rowNo;
    private Class<?> fieldClass;
    private Class<?> recordClass;
    private Class<?> tableClass;
    private Method tableOpenMethod;
    private Method tableGetFieldsMethod;
    private Method tableCloseMethod;
    private Method fieldGetNameMethod;
    private Method tableGetRecordCountMethod;
    private Method tableGetRecordAtMethod;
    private Method recordGetTypedValueMethod;
    private Method fieldGetTypeMethod;
    private Method fieldGetLengthMethod;
    private Map<String, String> dbfTypeToSQLType;
    private String upperTableName;
    private String tableAlias;
    private String[] columnNames = null;

    public DbfReader(String string, String string2, String string3, String string4) throws SQLException {
        try {
            this.fieldClass = Class.forName("nl.knaw.dans.common.dbflib.Field");
            this.recordClass = Class.forName("nl.knaw.dans.common.dbflib.Record");
            this.tableClass = Class.forName("nl.knaw.dans.common.dbflib.Table");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DbfClassNotFoundException(CsvResources.getString("noDansDbf") + ": " + classNotFoundException);
        }
        try {
            this.tableOpenMethod = this.tableClass.getMethod("open", new Class[0]);
            this.tableCloseMethod = this.tableClass.getMethod("close", new Class[0]);
            this.tableGetFieldsMethod = this.tableClass.getMethod("getFields", new Class[0]);
            this.fieldGetNameMethod = this.fieldClass.getMethod("getName", new Class[0]);
            this.tableGetRecordCountMethod = this.tableClass.getMethod("getRecordCount", new Class[0]);
            this.tableGetRecordAtMethod = this.tableClass.getMethod("getRecordAt", Integer.TYPE);
            this.recordGetTypedValueMethod = this.recordClass.getMethod("getTypedValue", String.class);
            this.fieldGetTypeMethod = this.fieldClass.getMethod("getType", new Class[0]);
            this.fieldGetLengthMethod = this.fieldClass.getMethod("getLength", new Class[0]);
        }
        catch (Exception exception) {
            throw new SQLException(CsvResources.getString("dansDbfError") + ": " + exception);
        }
        try {
            if (string4 != null) {
                Constructor<?> constructor = this.tableClass.getConstructor(File.class, String.class);
                this.table = constructor.newInstance(new File(string), string4);
            } else {
                Constructor<?> constructor = this.tableClass.getConstructor(File.class);
                this.table = constructor.newInstance(new File(string));
            }
            this.tableOpenMethod.invoke(this.table, new Object[0]);
            this.fields = (List)this.tableGetFieldsMethod.invoke(this.table, new Object[0]);
            this.recordCount = (Integer)this.tableGetRecordCountMethod.invoke(this.table, new Object[0]);
            this.record = null;
            this.rowNo = -1;
            this.upperTableName = string2.toUpperCase();
            this.tableAlias = string3;
        }
        catch (Exception exception) {
            throw new SQLException(CsvResources.getString("dansDbfError") + ": " + exception);
        }
        this.dbfTypeToSQLType = new HashMap<String, String>();
        this.dbfTypeToSQLType.put("CHARACTER", "String");
        this.dbfTypeToSQLType.put("NUMBER", "Double");
        this.dbfTypeToSQLType.put("LOGICAL", "Boolean");
        this.dbfTypeToSQLType.put("DATE", "Date");
        this.dbfTypeToSQLType.put("MEMO", "String");
        this.dbfTypeToSQLType.put("FLOAT", "Double");
    }

    @Override
    public void close() throws SQLException {
        if (this.table != null) {
            try {
                this.tableCloseMethod.invoke(this.table, new Object[0]);
            }
            catch (Exception exception) {
                throw new SQLException(CsvResources.getString("dansDbfError") + ": " + exception);
            }
        }
        this.table = null;
    }

    @Override
    public String[] getColumnNames() throws SQLException {
        if (this.columnNames == null) {
            int n = this.fields.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                Object e = this.fields.get(i);
                try {
                    stringArray[i] = (String)this.fieldGetNameMethod.invoke(e, new Object[0]);
                    continue;
                }
                catch (Exception exception) {
                    throw new SQLException(CsvResources.getString("dansDbfError") + ": " + exception);
                }
            }
            this.columnNames = stringArray;
        }
        return this.columnNames;
    }

    private Object getField(int n) throws SQLException {
        try {
            String[] stringArray = this.getColumnNames();
            String string = stringArray[n];
            Object object = this.recordGetTypedValueMethod.invoke(this.record, string);
            if (object instanceof String) {
                object = ((String)object).trim();
            } else if (object instanceof Date) {
                object = new java.sql.Date(((Date)object).getTime());
            }
            return object;
        }
        catch (Exception exception) {
            throw new SQLException(CsvResources.getString("dansDbfError") + ": " + exception);
        }
    }

    @Override
    public boolean next() throws SQLException {
        ++this.rowNo;
        if (this.rowNo >= this.recordCount) {
            return false;
        }
        try {
            this.record = this.tableGetRecordAtMethod.invoke(this.table, this.rowNo);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException.getCause());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public String[] getColumnTypes() throws SQLException {
        String[] stringArray = new String[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            String string = "";
            try {
                string = this.fieldGetTypeMethod.invoke(this.fields.get(i), new Object[0]).toString();
            }
            catch (Exception exception) {
                throw new SQLException(CsvResources.getString("dansDbfError") + ": " + exception);
            }
            stringArray[i] = this.dbfTypeToSQLType.get(string);
            if (stringArray[i] != null) continue;
            throw new SQLException(CsvResources.getString("dbfTypeNotSupported") + ": " + string);
        }
        return stringArray;
    }

    @Override
    public int[] getColumnSizes() throws SQLException {
        int[] nArray = new int[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            try {
                Object object = this.fieldGetLengthMethod.invoke(this.fields.get(i), new Object[0]);
                nArray[i] = ((Number)object).intValue();
                continue;
            }
            catch (Exception exception) {
                throw new SQLException(CsvResources.getString("dansDbfError") + ": " + exception);
            }
        }
        return nArray;
    }

    @Override
    public Map<String, Object> getEnvironment() throws SQLException {
        int n = this.fields.size() * 2;
        if (this.tableAlias != null) {
            n += this.fields.size();
        }
        if (n == 0) {
            n = 1;
        }
        MinimumMemoryMap<String, Object> minimumMemoryMap = new MinimumMemoryMap<String, Object>(n);
        for (int i = 0; i < this.fields.size(); ++i) {
            Object e = this.fields.get(i);
            try {
                String string = (String)this.fieldGetNameMethod.invoke(e, new Object[0]);
                Object object = this.getField(i);
                string = string.toUpperCase();
                minimumMemoryMap.put(string, object);
                minimumMemoryMap.put(this.upperTableName + "." + string, object);
                if (this.tableAlias == null) continue;
                minimumMemoryMap.put(this.tableAlias + "." + string, object);
                continue;
            }
            catch (Exception exception) {
                throw new SQLException(CsvResources.getString("dansDbfError") + ": " + exception);
            }
        }
        return minimumMemoryMap;
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }
}

