/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LogicalExpression;

class SearchedCaseExpression
extends Expression {
    private List<Expression> conditions;
    private List<Expression> values;
    private Expression elseExpression;

    public SearchedCaseExpression(List<Expression> list, List<Expression> list2, Expression expression) {
        this.conditions = list;
        this.values = list2;
        this.elseExpression = expression;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        for (int i = 0; i < this.conditions.size(); ++i) {
            Expression expression = this.conditions.get(i);
            if (!(expression instanceof LogicalExpression) || !expression.isValid()) {
                throw new SQLException(CsvResources.getString("caseNotLogical"));
            }
            Boolean bl = ((LogicalExpression)expression).isTrue(map);
            if (bl == null || !bl.booleanValue()) continue;
            return this.values.get(i).eval(map);
        }
        if (this.elseExpression != null) {
            return this.elseExpression.eval(map);
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("CASE");
        for (int i = 0; i < this.conditions.size(); ++i) {
            Expression expression = this.conditions.get(i);
            stringBuilder.append(" WHEN ").append(expression.toString()).append(" THEN ").append(this.values.get(i));
        }
        if (this.elseExpression != null) {
            stringBuilder.append(" ELSE ").append(this.elseExpression.toString());
        }
        stringBuilder.append(" END");
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator<Expression> iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(iterator.next().usedColumns(set));
        }
        iterator = this.values.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(iterator.next().usedColumns(set));
        }
        if (this.elseExpression != null) {
            linkedList.addAll(this.elseExpression.usedColumns(set));
        }
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        Iterator<Expression> iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(iterator.next().aggregateFunctions());
        }
        iterator = this.values.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(iterator.next().aggregateFunctions());
        }
        if (this.elseExpression != null) {
            linkedList.addAll(this.elseExpression.aggregateFunctions());
        }
        return linkedList;
    }
}

