/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLSubstringFunction
extends Expression {
    private static final Integer MAX_LENGTH = Integer.MAX_VALUE;
    Expression expr;
    Expression startIndex;
    Expression len;

    public SQLSubstringFunction(Expression expression, Expression expression2, Expression expression3) {
        this.expr = expression;
        this.startIndex = expression2;
        this.len = expression3;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        Object object;
        Object object2 = null;
        Object object3 = this.expr.eval(map);
        if (object3 != null && (object = this.startIndex.eval(map)) != null) {
            if (this.len != null) {
                Object object4 = this.len.eval(map);
                if (object4 != null) {
                    object2 = this.substring(object3, object, object4);
                }
            } else {
                object2 = this.substring(object3, object, MAX_LENGTH);
            }
        }
        return object2;
    }

    private Object substring(Object object, Object object2, Object object3) throws SQLException {
        int n = 0;
        long l = 0L;
        String string = null;
        boolean bl = false;
        if (object2 instanceof Number) {
            n = ((Number)object2).intValue();
        } else {
            try {
                n = Integer.parseInt(object2.toString());
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        if (object3 instanceof Number) {
            l = ((Number)object3).intValue();
        } else {
            try {
                l = Integer.parseInt(object3.toString());
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        if (!bl) {
            String string2;
            if (--n < 0) {
                l += (long)n;
                n = 0;
            }
            if (l < 0L) {
                l = 0L;
            }
            if (n >= (string2 = object.toString()).length()) {
                string = "";
            } else {
                long l2 = (long)n + l;
                if (l2 > (long)string2.length()) {
                    l2 = string2.length();
                }
                string = string2.substring(n, (int)l2);
            }
        }
        return string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SUBSTRING(");
        stringBuilder.append(this.expr);
        stringBuilder.append(",");
        stringBuilder.append(this.startIndex);
        if (this.len != null) {
            stringBuilder.append(",");
            stringBuilder.append(this.len);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.expr.usedColumns(set));
        linkedList.addAll(this.startIndex.usedColumns(set));
        if (this.len != null) {
            linkedList.addAll(this.len.usedColumns(set));
        }
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.expr.aggregateFunctions());
        linkedList.addAll(this.startIndex.aggregateFunctions());
        if (this.len != null) {
            linkedList.addAll(this.len.aggregateFunctions());
        }
        return linkedList;
    }
}

