/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLLengthFunction
extends Expression {
    Expression expression;

    public SQLLengthFunction(Expression expression) {
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        Object object = this.expression.eval(map);
        if (object != null) {
            object = object.toString().length();
        }
        return object;
    }

    public String toString() {
        return "LENGTH(" + this.expression + ")";
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.expression.usedColumns(set));
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.expression.aggregateFunctions());
        return linkedList;
    }
}

