/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MinimumMemoryMap<K, V>
implements Map<K, V> {
    ArrayList<K> keys;
    ArrayList<V> values;
    private KeyHashCodeComparator keyHashCodeComparator = new KeyHashCodeComparator();

    public MinimumMemoryMap() {
        this.keys = new ArrayList();
        this.values = new ArrayList();
    }

    public MinimumMemoryMap(int n) {
        this.keys = new ArrayList(n);
        this.values = new ArrayList(n);
    }

    public MinimumMemoryMap(Map<K, V> map) {
        this.keys = new ArrayList();
        this.values = new ArrayList();
        this.putAll(map);
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    private int binarySearch(ArrayList<K> arrayList, K k) {
        int n = Collections.binarySearch(arrayList, k, this.keyHashCodeComparator);
        if (n >= 0) {
            if (arrayList.get(n).equals(k)) {
                return n;
            }
            for (int i = n - 1; i >= 0; --i) {
                K k2 = arrayList.get(i);
                if (k.hashCode() != k2.hashCode()) break;
                if (!k2.equals(k)) continue;
                return i;
            }
            for (int i = n + 1; i < arrayList.size(); ++i) {
                K k3 = arrayList.get(i);
                if (k.hashCode() != k3.hashCode()) break;
                if (!k3.equals(k)) continue;
                return i;
            }
            ++n;
            n = -n;
        }
        return n;
    }

    @Override
    public boolean containsKey(Object object) {
        int n = this.binarySearch(this.keys, object);
        return n >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.values.contains(object);
    }

    @Override
    public V get(Object object) {
        int n = this.binarySearch(this.keys, object);
        if (n >= 0) {
            return this.values.get(n);
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        V v2 = null;
        int n = this.binarySearch(this.keys, k);
        if (n >= 0) {
            v2 = this.values.get(n);
            this.values.set(n, v);
        } else {
            n = -n;
            this.keys.add(--n, k);
            this.values.add(n, v);
        }
        return v2;
    }

    @Override
    public V remove(Object object) {
        V v = null;
        int n = this.binarySearch(this.keys, object);
        if (n >= 0) {
            v = this.values.get(n);
            this.keys.remove(n);
            this.values.remove(n);
        }
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = this.size() + map.size();
        this.keys.ensureCapacity(n);
        this.values.ensureCapacity(n);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        return new HashSet<K>(this.keys);
    }

    @Override
    public Collection<V> values() {
        return new ArrayList<V>(this.values);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        int n = this.keys.size();
        HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>(n);
        for (int i = 0; i < n; ++i) {
            hashSet.add(new AbstractMap.SimpleEntry<K, V>(this.keys.get(i), this.values.get(i)));
        }
        return hashSet;
    }

    public String toString() {
        return this.entrySet().toString();
    }

    private class KeyHashCodeComparator
    implements Comparator<K> {
        private KeyHashCodeComparator() {
        }

        @Override
        public int compare(K k, K k2) {
            int n;
            int n2 = k != null ? k.hashCode() : 0;
            int n3 = n = k2 != null ? k2.hashCode() : 0;
            if (n2 == n) {
                return 0;
            }
            if (n2 < n) {
                return -1;
            }
            return 1;
        }
    }
}

