/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.LikePattern;
import org.relique.jdbc.csv.LogicalExpression;

class LikeExpression
extends LogicalExpression {
    Expression arg1;
    Expression arg2;
    Expression escapeArg;

    public LikeExpression(Expression expression, Expression expression2, Expression expression3) {
        this.arg1 = expression;
        this.arg2 = expression2;
        this.escapeArg = expression3;
    }

    @Override
    public Boolean isTrue(Map<String, Object> map) throws SQLException {
        Object object;
        Object object2 = this.arg1.eval(map);
        Object object3 = this.arg2.eval(map);
        String string = "\\";
        if (this.escapeArg != null) {
            String string2;
            string = "";
            object = this.escapeArg.eval(map);
            if (object != null && (string2 = object.toString()).length() > 0) {
                string = string2.substring(0, 1);
            }
        }
        object = null;
        if (object2 != null && object3 != null) {
            object = LikePattern.matches(object3.toString(), string, object2.toString());
        }
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("L ");
        stringBuilder.append(this.arg1);
        stringBuilder.append(" ");
        stringBuilder.append(this.arg2);
        if (this.escapeArg != null) {
            stringBuilder.append(" ESCAPE ");
            stringBuilder.append(this.escapeArg);
        }
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.arg1.usedColumns(set));
        linkedList.addAll(this.arg2.usedColumns(set));
        if (this.escapeArg != null) {
            linkedList.addAll(this.escapeArg.usedColumns(set));
        }
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.arg1.aggregateFunctions());
        linkedList.addAll(this.arg2.aggregateFunctions());
        if (this.escapeArg != null) {
            linkedList.addAll(this.escapeArg.aggregateFunctions());
        }
        return linkedList;
    }
}

