/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.utils;

import com.sybase.jdbc4.jdbc.SybSavepoint;
import com.sybase.jdbc4.utils.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogUtil
extends Formatter {
    Date dat = new Date(0L);
    private String _format = "{0,date} {0,time}";
    private Object[] args = new Object[1];
    private MessageFormat formatter;
    private final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String ID_SEPARATOR = "`";
    private static LogManager _logManager = LogManager.getLogManager();
    private static FileHandler _fileHandler = null;
    private static final String LOG_FILE = System.getProperty("java.io.tmpdir") + "jconn4%u.log";

    public static void logBegin(Logger logger, String string, long l) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(string + ID_SEPARATOR + l);
        }
    }

    public static final void logEnd(Logger logger, String string, String string2, String string3, String string4, String string5, Object[] objectArray, long l) {
        if (logger.isLoggable(Level.FINER)) {
            if (string == null && string2 == null) {
                logger.finer(string3 + ID_SEPARATOR + l + " " + string3 + "." + string4 + "(" + LogUtil.objectArrayToString(objectArray) + ");");
            } else {
                logger.finer(string3 + ID_SEPARATOR + l + " " + string + " " + string2 + " = " + string3 + "." + string4 + "(" + LogUtil.objectArrayToString(objectArray) + ");");
            }
        } else if (logger.isLoggable(Level.FINE)) {
            // empty if block
        }
    }

    private static String objectArrayToString(Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            stringBuilder.append(LogUtil.objectToString(object)).append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static String objectToString(Object object) {
        if (object instanceof String) {
            if (object == null) {
                return null;
            }
            return "\"" + LogUtil.enQuoteString(object.toString()) + "\"";
        }
        if (object instanceof int[]) {
            StringBuffer stringBuffer = new StringBuffer("new int[] {");
            for (int i = 0; i < ((int[])object).length; ++i) {
                stringBuffer.append(((int[])object)[i]).append(",");
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
            }
            return stringBuffer.toString();
        }
        if (object instanceof String[]) {
            StringBuffer stringBuffer = new StringBuffer("new String[] {");
            for (int i = 0; i < ((String[])object).length; ++i) {
                stringBuffer.append(LogUtil.enQuoteString(((String[])object)[i])).append(",");
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
            }
            return stringBuffer.toString();
        }
        if (object instanceof byte[]) {
            StringBuffer stringBuffer = new StringBuffer("new byte[] {");
            for (int i = 0; i < ((byte[])object).length; ++i) {
                stringBuffer.append(((byte[])object)[i]).append(",");
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
            }
            return stringBuffer.toString();
        }
        if (object instanceof Savepoint) {
            SybSavepoint sybSavepoint = (SybSavepoint)object;
            return sybSavepoint.getLogId();
        }
        if (object instanceof Properties) {
            Properties properties = (Properties)object;
            StringBuffer stringBuffer = new StringBuffer();
            if (properties.isEmpty()) {
                return "new Properties()";
            }
            for (Object object2 : properties.keySet()) {
                Object object3 = properties.get(object2);
                if (object3 instanceof String) {
                    object3 = LogUtil.enQuoteString(object3.toString());
                }
                stringBuffer.append("prop.put(\"").append(object2).append("\"").append(", \"").append(object3).append("\");");
            }
            return stringBuffer.toString();
        }
        if (!(object instanceof Map)) {
            if (object instanceof Object[]) {
                StringBuffer stringBuffer = new StringBuffer("new Object[] {");
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    stringBuffer.append(((Object[])object)[i]).append(",");
                }
                if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                    stringBuffer.setCharAt(stringBuffer.length() - 1, '}');
                }
                return stringBuffer.toString();
            }
            if (object instanceof Class) {
                return ((Class)object).getName();
            }
            if (object instanceof Date) {
                return ((Date)object).toString();
            }
            if (object instanceof Time) {
                return ((Time)object).toString();
            }
            if (object instanceof Timestamp) {
                return ((Timestamp)object).toString();
            }
            if (object instanceof InputStream) {
                try {
                    return "InputStream.available = [" + ((InputStream)object).available();
                }
                catch (IOException iOException) {
                    return "InputStream =[?";
                }
            }
            if (object instanceof URL) {
                return ((URL)object).toString();
            }
            if (object instanceof Reader) {
                return "Reader.hashCode = [" + ((Reader)object).toString();
            }
            if (object instanceof Blob) {
                try {
                    return "Blob.length = [" + ((Blob)object).length();
                }
                catch (SQLException sQLException) {
                    return "Blob = [?";
                }
            }
            if (object instanceof Clob) {
                try {
                    return "Clob.length = [" + ((Clob)object).length();
                }
                catch (SQLException sQLException) {
                    return "Clob = [?";
                }
            }
            if (object instanceof NClob) {
                try {
                    return "NClob = [" + ((NClob)object).length() + "";
                }
                catch (SQLException sQLException) {
                    return "NClob = [?";
                }
            }
            if (object instanceof Ref) {
                try {
                    return "Ref.BaseTypeName = [" + ((Ref)object).getBaseTypeName();
                }
                catch (SQLException sQLException) {
                    return "Ref = [?";
                }
            }
            if (object instanceof Array) {
                try {
                    return "Array.hashcode = [" + ((Array)object).getArray().toString();
                }
                catch (SQLException sQLException) {
                    return "Array = [?";
                }
            }
            if (object instanceof Calendar) {
                return "Calendar = [" + ((Calendar)object).toString();
            }
            if (object instanceof RowId) {
                return "RowId = [" + ((Object)((RowId)object)).toString();
            }
            if (object instanceof SQLXML) {
                try {
                    return "SQLXML.getString = [" + ((SQLXML)object).getString();
                }
                catch (SQLException sQLException) {
                    return "SQLXML = [?";
                }
            }
            if (object instanceof Integer) {
                return (Integer)object + "";
            }
            if (object instanceof Long) {
                return "" + (Long)object;
            }
            if (object instanceof Byte) {
                return "new Byte(" + (Byte)object + ")";
            }
            if (object instanceof PrintWriter) {
                return "PrintWriter = [ " + ((PrintWriter)object).getClass();
            }
            if (object instanceof BigDecimal) {
                return "new BigDecimal(\"" + (object != null ? object.toString() : "\"0") + "\")";
            }
            if (object instanceof Timestamp) {
                return object != null ? "Timestamp.valueOf(\"" + object.toString() + "\")" : "null";
            }
        }
        return object != null ? object.toString() : "null";
    }

    private static String enQuoteString(String string) {
        if (string != null) {
            string = string.replaceAll("\"", "\\\"");
            return string.replaceAll("\n", " ");
        }
        return string;
    }

    @Override
    public String format(LogRecord logRecord) {
        Appendable appendable;
        StringBuilder stringBuilder = new StringBuilder();
        if (logRecord.getLevel() == Level.FINE) {
            this.dat.setTime(logRecord.getMillis());
            this.args[0] = this.dat;
            appendable = new StringBuffer();
            if (this.formatter == null) {
                this.formatter = new MessageFormat(this._format);
            }
            this.formatter.format(this.args, (StringBuffer)appendable, (FieldPosition)null);
            stringBuilder.append((StringBuffer)appendable);
            stringBuilder.append(" ");
            stringBuilder.append(logRecord.getLevel().getLocalizedName());
            stringBuilder.append("   : ");
        } else if (logRecord.getLevel() != Level.FINER) {
            stringBuilder.append(" : ");
        }
        stringBuilder.append(this.formatMessage(logRecord));
        stringBuilder.append(this.LINE_SEPARATOR);
        if (logRecord.getThrown() != null) {
            appendable = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)appendable);
            logRecord.getThrown().printStackTrace(printWriter);
            printWriter.close();
            stringBuilder.append(((StringWriter)appendable).toString());
        }
        return stringBuilder.toString();
    }

    public static final boolean isLoggingEnabled(Logger logger) {
        return logger.getLevel() != null && logger.getLevel().intValue() <= Level.FINE.intValue() && Thread.currentThread().getStackTrace()[3].toString().indexOf("com.sybase.jdbc4") == -1;
    }

    public static Integer getAPICallCount(HashMap<String, Integer> hashMap, String string) {
        Integer n = hashMap.get(string);
        hashMap.put(string, n != null ? (n = Integer.valueOf(n + 1)) : (n = Integer.valueOf(1)));
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        if (stringArray == null || stringArray.length < 1) {
            Debug.println("Syntax Error: Usage java com.sybase.jdbc4.utils.LogUtil /tmp/abcd.log /tmp/A.java");
            return;
        }
        String string = stringArray[0];
        String string2 = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
        PrintStream printStream = new PrintStream(System.out);
        if (!new File(string).exists()) {
            Debug.println("The log File " + string + " does not exist");
            bufferedReader.close();
            return;
        }
        if (stringArray.length > 1) {
            string2 = stringArray[1];
            if (!new File(string2).canWrite()) {
                Debug.println("Unable to write to file " + string2 + " writing to console instead...");
            } else {
                Debug.println("Writing to File : " + string2);
                printStream.close();
                printStream = new PrintStream(string2);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        printStream.println("/* Automatically Generated Replayable Log */");
        printStream.println("import java.sql.*;");
        printStream.println("import java.util.*;");
        printStream.println("import java.math.BigDecimal;");
        printStream.println("import com.sybase.jdbc4.jdbc.*;");
        printStream.println("public class " + string);
        printStream.println("{");
        while ((string3 = bufferedReader.readLine()) != null) {
            int n7 = n2 = string3.indexOf(32) == -1 ? 1 : 0;
            if (n2 != 0) {
                arrayList.add(string3);
                ++n5;
                continue;
            }
            ++n6;
            n3 = string3.indexOf(32);
            n4 = arrayList.indexOf(string3.substring(0, n3));
            arrayList.remove(n4);
            arrayList.add(n4, string3.substring(n3 + 1));
        }
        printStream.println("\tpublic static SybDriver Dr0 = new SybDriver();");
        printStream.println("\tpublic static Properties prop = new Properties();");
        n2 = 1;
        for (n = 0; n < arrayList.size(); ++n) {
            if (n % 1000 == 0) {
                if (n2 > 1) {
                    printStream.println("\t}\n");
                }
                printStream.println("\tpublic static void m" + n2++ + "() throws Exception");
                printStream.println("\t{");
                printStream.println("\t\tSystem.out.println(\"m" + (n2 - 1) + "()\");");
            }
            printStream.println("\t\t" + (String)arrayList.get(n));
        }
        printStream.println("\t}");
        printStream.println("\tpublic static void main(String[] args) throws Exception");
        printStream.println("\t{");
        for (n = 1; n < n2; ++n) {
            printStream.println("\t\tm" + n + "();");
        }
        printStream.println("\t}\n}");
        printStream.close();
    }
}

