/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsOutputStream;
import java.io.IOException;

public class RowDataFormat2
extends DataFormat {
    protected String _labelName;
    protected byte[] _labelNameBytes;
    protected int _labelLen;
    protected String _catalogName;
    protected byte[] _catalogNameBytes;
    protected int _catalogLen;
    protected String _schemaName;
    protected byte[] _schemaNameBytes;
    protected int _schemaLen;
    protected int _tableLen;
    protected byte[] _tableNameBytes;
    protected boolean _labelNameEmpty = false;

    protected RowDataFormat2() {
    }

    public RowDataFormat2(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream, true);
    }

    public RowDataFormat2(TdsInputStream tdsInputStream, boolean bl) throws IOException {
        super(tdsInputStream, bl);
    }

    @Override
    protected void readMetaInfo(TdsInputStream tdsInputStream) throws IOException {
        try {
            this._labelLen = tdsInputStream.readUnsignedByte();
            if (this._labelLen > 0) {
                this._labelNameBytes = new byte[this._labelLen];
                tdsInputStream.read(this._labelNameBytes, 0, this._labelLen);
            } else {
                this._labelNameEmpty = true;
            }
            this._catalogLen = tdsInputStream.readUnsignedByte();
            if (this._catalogLen > 0) {
                this._catalogNameBytes = new byte[this._catalogLen];
                tdsInputStream.read(this._catalogNameBytes, 0, this._catalogLen);
            }
            this._schemaLen = tdsInputStream.readUnsignedByte();
            if (this._schemaLen > 0) {
                this._schemaNameBytes = new byte[this._schemaLen];
                tdsInputStream.read(this._schemaNameBytes, 0, this._schemaLen);
            }
            this._tableLen = tdsInputStream.readUnsignedByte();
            if (this._tableLen > 0) {
                this._tableNameBytes = new byte[this._tableLen];
                tdsInputStream.read(this._tableNameBytes, 0, this._tableLen);
            }
            this._nameLen = tdsInputStream.readUnsignedByte();
            if (this._nameLen > 0) {
                this._nameBytes = new byte[this._nameLen];
                tdsInputStream.read(this._nameBytes, 0, this._nameLen);
                if (this._labelNameEmpty) {
                    this._labelNameBytes = this._nameBytes;
                    this._labelLen = this._nameLen;
                }
            }
        }
        catch (IOException iOException) {
            RowDataFormat2.readSQE(iOException);
        }
    }

    @Override
    protected void readStatus(TdsInputStream tdsInputStream) throws IOException {
        this._status = tdsInputStream.readInt();
    }

    public String getLabelName() {
        if (this._labelName != null) {
            return this._labelName;
        }
        if (this._labelLen == 0) {
            this._labelName = "";
            return this._labelName;
        }
        try {
            this._labelName = this._tdsIn.convertBytesToString(this._labelNameBytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._labelName;
    }

    public String getCatalogName() {
        if (this._catalogName != null) {
            return this._catalogName;
        }
        if (this._catalogLen == 0) {
            this._catalogName = "";
            return this._catalogName;
        }
        try {
            this._catalogName = this._tdsIn.convertBytesToString(this._catalogNameBytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._catalogName;
    }

    public String getSchemaName() {
        if (this._schemaName != null) {
            return this._schemaName;
        }
        if (this._schemaLen == 0) {
            this._schemaName = "";
            return this._schemaName;
        }
        try {
            this._schemaName = this._tdsIn.convertBytesToString(this._schemaNameBytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._schemaName;
    }

    public String getTableName() {
        if (this._tableName != null) {
            return this._tableName;
        }
        if (this._tableLen == 0) {
            this._tableName = "";
            return this._tableName;
        }
        try {
            this._tableName = this._tdsIn.convertBytesToString(this._tableNameBytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._tableName;
    }

    @Override
    public int length() {
        int n = super.length();
        return n += 7 + (this._labelName == null || this._labelName.equals("") ? 0 : this._labelName.length()) + (this._catalogName == null ? 0 : this._catalogName.length()) + (this._schemaName == null ? 0 : this._schemaName.length()) + (this._tableName == null ? 0 : this._tableName.length());
    }

    @Override
    protected void sendMetaInfo(TdsOutputStream tdsOutputStream) throws IOException {
        byte[] byArray;
        if (this._labelName == null || this._labelName.equals("")) {
            tdsOutputStream.writeByte(0);
        } else {
            byArray = tdsOutputStream.stringToByte(this._labelName);
            tdsOutputStream.writeByte(byArray.length);
            tdsOutputStream.write(byArray);
        }
        if (this._catalogName == null || this._catalogName.equals("")) {
            tdsOutputStream.writeByte(0);
        } else {
            byArray = tdsOutputStream.stringToByte(this._catalogName);
            tdsOutputStream.writeByte(byArray.length);
            tdsOutputStream.write(byArray);
        }
        if (this._schemaName == null || this._schemaName.equals("")) {
            tdsOutputStream.writeByte(0);
        } else {
            byArray = tdsOutputStream.stringToByte(this._schemaName);
            tdsOutputStream.writeByte(byArray.length);
            tdsOutputStream.write(byArray);
        }
        if (this._tableName == null || this._tableName.equals("")) {
            tdsOutputStream.writeByte(0);
        } else {
            byArray = tdsOutputStream.stringToByte(this._tableName);
            tdsOutputStream.writeByte(byArray.length);
            tdsOutputStream.write(byArray);
        }
        if (this._name == null || this._name.equals("")) {
            tdsOutputStream.writeByte(0);
        } else {
            byArray = tdsOutputStream.stringToByte(this._name);
            tdsOutputStream.writeByte(byArray.length);
            tdsOutputStream.write(byArray);
        }
    }

    @Override
    protected void sendStatus(TdsOutputStream tdsOutputStream) throws IOException {
        tdsOutputStream.writeInt(this._status);
    }
}

