/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.EncryptionKeys;

final class Encryption {
    private static final int FEALENC_KEYNUM = 16;
    private static final int FEALENC_MAX_CYCLE = 8;
    static final int CIPHERLEN = 32;
    private static final int NUM_NETKEY = 256;
    private static final int CHALLENGE_LEN = 8;
    private static final int SALT = 87;
    private static final int MAX_PAD_LENGTH = 30;
    private static final byte PAD_CHAR = 92;
    private static final int ENCRYPTION_CONSTANT_1 = 3;
    private static final int ENCRYPTION_CONSTANT_2 = 254;
    private static final int ENCRYPTION_CONSTANT_3 = 0;
    private static final int DOCTETSIZE = 2;
    private static final int QOCTETSIZE = 4;
    private static final int OOCTETSIZE = 8;
    private static final byte[] _null4 = new byte[]{0, 0, 0, 0};
    private byte[][][] _netKey = null;
    private int _ooctes_per_cipher = 4;

    Encryption() {
    }

    private void feal_fk(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte by = (byte)(byArray[0] ^ byArray[1]);
        byte by2 = (byte)(byArray[2] ^ byArray[3]);
        by = this.feal_sbox(by, by2 ^ byArray2[0], 1);
        by2 = this.feal_sbox(by2, by ^ byArray2[1], 0);
        byte by3 = this.feal_sbox(byArray[0], by ^ byArray2[2], 0);
        byte by4 = this.feal_sbox(byArray[3], by2 ^ byArray2[3], 1);
        this.OCat4(byArray3, by3, by, by2, by4);
    }

    private void feal_cipher(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte by = (byte)(byArray[1] ^ byArray2[0] ^ byArray[0]);
        byte by2 = (byte)(byArray[2] ^ byArray2[1] ^ byArray[3]);
        by = this.feal_sbox(by, by2, 1);
        by2 = this.feal_sbox(by2, by, 0);
        byte by3 = this.feal_sbox(byArray[0], by, 0);
        byte by4 = this.feal_sbox(byArray[3], by2, 1);
        this.OCat4(byArray3, by3, by, by2, by4);
    }

    private void feal_keysch(byte[] byArray, byte[][] byArray2) {
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[4];
        this.OSep8to4(byArray, byArray3, byArray4);
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = new byte[4];
        byte[] byArray7 = new byte[4];
        for (int i = 1; i <= 8; ++i) {
            this.OSetAny(byArray5, byArray3);
            this.OSetAny(byArray3, byArray4);
            this.Xor(4, byArray4, byArray6, byArray7);
            this.feal_fk(byArray5, byArray7, byArray4);
            this.OCat2(byArray2[2 * (i - 1)], byArray4[0], byArray4[1]);
            this.OCat2(byArray2[2 * (i - 1) + 1], byArray4[2], byArray4[3]);
        }
    }

    private void feal_encrypt(byte[] byArray, byte[] byArray2, byte[][] byArray3) {
        byte[] byArray4 = new byte[8];
        this.OJoin2to8(byArray4, byArray3[8], byArray3[9], byArray3[10], byArray3[11]);
        byte[] byArray5 = new byte[8];
        this.OSetAny(byArray5, byArray);
        this.Xor(8, byArray5, byArray4, byArray5);
        this.OJoinAny(byArray4, _null4, byArray5);
        this.Xor(8, byArray5, byArray4, byArray5);
        byte[] byArray6 = new byte[4];
        byte[] byArray7 = new byte[4];
        this.OSep8to4(byArray5, byArray6, byArray7);
        byte[] byArray8 = new byte[4];
        byte[] byArray9 = new byte[4];
        for (int i = 1; i <= 8; ++i) {
            this.OSetAny(byArray8, byArray7);
            this.feal_cipher(byArray7, byArray3[i - 1], byArray9);
            this.Xor(4, byArray6, byArray9, byArray7);
            this.OSetAny(byArray6, byArray8);
        }
        this.OJoinAny(byArray5, byArray7, byArray6);
        this.OJoinAny(byArray4, _null4, byArray7);
        this.Xor(8, byArray5, byArray4, byArray5);
        this.OJoin2to8(byArray4, byArray3[12], byArray3[13], byArray3[14], byArray3[15]);
        this.Xor(8, byArray5, byArray4, byArray5);
        this.OSetAny(byArray2, byArray5);
    }

    private void feal_decrypt(byte[] byArray, byte[] byArray2, byte[][] byArray3) {
        byte[] byArray4 = new byte[8];
        this.OJoin2to8(byArray4, byArray3[12], byArray3[13], byArray3[14], byArray3[15]);
        byte[] byArray5 = new byte[8];
        this.OSetAny(byArray5, byArray);
        this.Xor(8, byArray5, byArray4, byArray5);
        this.OJoinAny(byArray4, _null4, byArray5);
        this.Xor(8, byArray5, byArray4, byArray5);
        byte[] byArray6 = new byte[4];
        byte[] byArray7 = new byte[4];
        this.OSep8to4(byArray5, byArray7, byArray6);
        byte[] byArray8 = new byte[4];
        byte[] byArray9 = new byte[4];
        for (int i = 8; i >= 1; --i) {
            this.OSetAny(byArray8, byArray6);
            this.feal_cipher(byArray6, byArray3[i - 1], byArray9);
            this.Xor(4, byArray7, byArray9, byArray6);
            this.OSetAny(byArray7, byArray8);
        }
        this.OJoinAny(byArray5, byArray6, byArray7);
        this.OJoinAny(byArray4, _null4, byArray6);
        this.Xor(8, byArray5, byArray4, byArray5);
        this.OJoin2to8(byArray4, byArray3[8], byArray3[9], byArray3[10], byArray3[11]);
        this.Xor(8, byArray5, byArray4, byArray5);
        this.OSetAny(byArray2, byArray5);
    }

    int pwd_encrypt(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3) {
        int n3;
        int n4;
        if (n != 8) {
            return 0;
        }
        int n5 = n2 > 30 ? 30 : n2;
        byte[] byArray4 = new byte[32];
        this.pad(byArray2, n5, byArray[0], byArray4);
        byte[][] byArray5 = new byte[this._ooctes_per_cipher][8];
        for (n4 = 0; n4 < this._ooctes_per_cipher; ++n4) {
            for (n3 = 0; n3 < 8; ++n3) {
                byArray5[n4][n3] = byArray4[n4 * 8 + n3];
            }
        }
        byte[] byArray6 = new byte[8];
        for (n4 = 0; n4 < this._ooctes_per_cipher; ++n4) {
            this.char_encrypt(byArray5[n4], byArray, byArray6, n4);
            for (n3 = 0; n3 < 8; ++n3) {
                byArray3[n4 * 8 + n3] = byArray6[n3];
            }
        }
        return n2;
    }

    private void char_encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        if (this._netKey == null) {
            this.derive_keys();
        }
        byte[][] byArray4 = new byte[16][2];
        this.feal_keysch(this._netKey[(byArray2[0] & 0xFF) % 254 + 2][n], byArray4);
        byte[] byArray5 = new byte[8];
        this.feal_encrypt(byArray, byArray5, byArray4);
        int n2 = 0;
        byte[] byArray6 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            n2 = byArray2[i] & 0xFF | 1 << 8 - (i + 1);
            this.OSetAny(byArray6, byArray5);
            if (n2 != 0) {
                this.feal_keysch(this._netKey[((byArray2[i] & 0xFF) + i) * 3 % 254 + 2][n], byArray4);
                this.feal_encrypt(byArray6, byArray5, byArray4);
                continue;
            }
            this.localization_convert(byArray6, byArray2[i], byArray5);
        }
        this.OSetAny(byArray3, byArray5);
    }

    private void derive_keys() {
        int n;
        int n2;
        this._netKey = new byte[256][this._ooctes_per_cipher][8];
        byte[][][] byArray = EncryptionKeys.EnKeys;
        for (n2 = 0; n2 < this._ooctes_per_cipher; ++n2) {
            for (n = 0; n < 8; ++n) {
                this._netKey[0][n2][n] = (byte)(byArray[0][n2][n] - 87);
            }
        }
        byte[][] byArray2 = new byte[16][2];
        for (n2 = 0; n2 < this._ooctes_per_cipher; ++n2) {
            this.feal_keysch(byArray[0][n2], byArray2);
            this.feal_decrypt(byArray[1][n2], this._netKey[1][n2], byArray2);
        }
        for (n2 = 2; n2 < 256; ++n2) {
            for (n = 0; n < this._ooctes_per_cipher; ++n) {
                this.Xor(8, byArray[n2 - 1][n], byArray[n2][n], this._netKey[n2][n]);
            }
        }
    }

    private void localization_convert(byte[] byArray, byte by, byte[] byArray2) {
        byArray2[0] = (byte)(by ^ byArray[0]);
        for (int i = 1; i < 8; ++i) {
            byArray2[i] = (byte)(byArray2[i - 1] ^ byArray[i]);
        }
    }

    private void pad(byte[] byArray, int n, byte by, byte[] byArray2) {
        int n2;
        for (n2 = 0; n2 < 32; ++n2) {
            byArray2[n2] = 92;
        }
        for (n2 = 0; n2 < n; ++n2) {
            byArray2[((by & 0xFF) + n2) % 32] = byArray[n2];
        }
    }

    private byte feal_sbox(byte by, int n, int n2) {
        return (byte)(((by & 0xFF) + (n & 0xFF) + n2) % 256 * 4 + (((by & 0xFF) + (n & 0xFF) + n2) % 256 >> 6));
    }

    private void Xor(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < n; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
    }

    private void OCat2(byte[] byArray, byte by, byte by2) {
        byArray[0] = by;
        byArray[1] = by2;
    }

    private void OCat4(byte[] byArray, byte by, byte by2, byte by3, byte by4) {
        byArray[0] = by;
        byArray[1] = by2;
        byArray[2] = by3;
        byArray[3] = by4;
    }

    private void OSetAny(byte[] byArray, byte[] byArray2) {
        if (byArray2.length != byArray.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = byArray2[i];
        }
    }

    private void OJoinAny(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length / 2) {
            byArray[n] = byArray2[n2];
            ++n2;
            ++n;
        }
        n2 = 0;
        while (n2 < byArray.length / 2) {
            byArray[n] = byArray3[n2];
            ++n2;
            ++n;
        }
    }

    private void OJoin2to8(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        byArray[0] = byArray2[0];
        byArray[1] = byArray2[1];
        byArray[2] = byArray3[0];
        byArray[3] = byArray3[1];
        byArray[4] = byArray4[0];
        byArray[5] = byArray4[1];
        byArray[6] = byArray5[0];
        byArray[7] = byArray5[1];
    }

    private void OSep8to4(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byArray2[0] = byArray[0];
        byArray2[1] = byArray[1];
        byArray2[2] = byArray[2];
        byArray2[3] = byArray[3];
        byArray3[0] = byArray[4];
        byArray3[1] = byArray[5];
        byArray3[2] = byArray[6];
        byArray3[3] = byArray[7];
    }
}

