/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LobLocatorBufferedInputStream;
import com.sybase.jdbc4.jdbc.LobLocatorInputStream;
import com.sybase.jdbc4.jdbc.LobLocatorOutputStream;
import com.sybase.jdbc4.jdbc.MdaManager;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class SybBinaryLob
extends SybLob
implements Blob {
    private static final Logger LOG = Logger.getLogger(SybBinaryLob.class.getName());
    private static volatile long _logIdCounter = 0L;
    private AtomicLong _apiCount = new AtomicLong(0L);

    public SybBinaryLob(String string, ProtocolContext protocolContext, byte[] byArray) throws SQLException {
        super(string, protocolContext, byArray);
        this._lobType = SybLob.LOB_TYPE.IMAGE;
        this.setLiteralSQL();
        this._lengthBuiltin = "datalength";
        this._logId = string + "_Bl" + _logIdCounter++;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new LobLocatorBufferedInputStream(new LobLocatorInputStream(this), 16384);
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        long l3 = this.length();
        if (l < 1L || l > l3 || l + l2 > l3 + 1L) {
            ErrorMessage.raiseError("JZ037");
        }
        return new LobLocatorBufferedInputStream(new LobLocatorInputStream(this, l, l2), 16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray;
        block13: {
            long l2;
            boolean bl;
            block9: {
                byte[] byArray2;
                block12: {
                    int n2;
                    block10: {
                        byte[] byArray3;
                        block11: {
                            bl = LogUtil.isLoggingEnabled(LOG);
                            l2 = bl ? this._apiCount.incrementAndGet() : 0L;
                            try {
                                if (bl) {
                                    LogUtil.logBegin(LOG, this._logId, l2);
                                }
                                this.checkLocatorValidity();
                                if (l < 1L) {
                                    ErrorMessage.raiseError("JZ037");
                                } else if (n < 0) {
                                    ErrorMessage.raiseError("JZ038");
                                }
                                MdaManager mdaManager = this._context._conn.getMDA(this._context);
                                PreparedStatement preparedStatement = mdaManager.getMetaDataAccessor("LOB_GETBYTES", this._context);
                                preparedStatement.setInt(1, this._lobType.ordinal());
                                preparedStatement.setBytes(2, this.getLocator());
                                preparedStatement.setLong(3, l);
                                preparedStatement.setInt(4, n);
                                ResultSet resultSet = preparedStatement.executeQuery();
                                if (!resultSet.next()) break block9;
                                byArray = resultSet.getBytes(1);
                                n2 = resultSet.getInt(2);
                                if (byArray == null) break block10;
                                byArray3 = byArray;
                                if (!bl) break block11;
                            }
                            catch (Throwable throwable) {
                                if (bl) {
                                    LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", "long, int", new Object[]{l, n}, l2);
                                }
                                throw throwable;
                            }
                            LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", "long, int", new Object[]{l, n}, l2);
                        }
                        return byArray3;
                    }
                    if (n2 == 0 || l > (long)n2) break block9;
                    byArray2 = new byte[]{};
                    if (!bl) break block12;
                    LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", "long, int", new Object[]{l, n}, l2);
                }
                return byArray2;
            }
            byArray = null;
            if (!bl) break block13;
            LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", "long, int", new Object[]{l, n}, l2);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        long l2;
        block7: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l3 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l3);
                }
                this.checkLocatorValidity();
                if (l < 1L) {
                    ErrorMessage.raiseError("JZ037");
                }
                long l4 = -1L;
                if (byArray != null) {
                    CallableStatement callableStatement = (CallableStatement)this._mda.getMetaDataAccessor("SEARCH_LOB", this._context);
                    callableStatement.setInt(1, this._lobType.ordinal());
                    callableStatement.setBytes(2, byArray);
                    callableStatement.setBytes(3, this.getLocator());
                    callableStatement.setLong(4, l);
                    callableStatement.registerOutParameter(5, -5);
                    callableStatement.setInt(6, 1);
                    callableStatement.setNull(7, 12);
                    callableStatement.execute();
                    l4 = callableStatement.getLong(5);
                    if (l4 < l) {
                        l4 = -1L;
                    }
                }
                l2 = l4;
                if (!bl) break block7;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "position", "byte[], long", new Object[]{byArray, l}, l3);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "position", "byte[], long", new Object[]{byArray, l}, l3);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(Blob blob, long l) throws SQLException {
        long l2;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l3 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l3);
                }
                l2 = super.searchLocator((SybLob)((Object)blob), l);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "position", "Blob, long", new Object[]{blob, l}, l3);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "position", "Blob, long", new Object[]{blob, l}, l3);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        int n;
        block7: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l2);
                }
                if (l < 1L) {
                    ErrorMessage.raiseError("JZ037");
                }
                int n2 = 0;
                if (byArray != null) {
                    this.checkLocatorValidity();
                    CallableStatement callableStatement = (CallableStatement)this._mda.getMetaDataAccessor("IMAGE_SETDATA", this._context);
                    callableStatement.setBytes(1, this.getLocator());
                    callableStatement.setLong(2, l);
                    callableStatement.setBytes(3, byArray);
                    callableStatement.registerOutParameter(4, 4);
                    callableStatement.execute();
                    n2 = callableStatement.getInt(4);
                    if (n2 == 0 && byArray.length != 0) {
                        ErrorMessage.raiseError("JZ037");
                    }
                }
                n = n2;
                if (!bl) break block7;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "setBytes", "long, byte[]", new Object[]{l, byArray}, l2);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "setBytes", "long, byte[]", new Object[]{l, byArray}, l2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        int n3;
        block7: {
            long l2;
            boolean bl;
            block5: {
                int n4;
                block6: {
                    bl = LogUtil.isLoggingEnabled(LOG);
                    l2 = bl ? this._apiCount.incrementAndGet() : 0L;
                    try {
                        if (bl) {
                            LogUtil.logBegin(LOG, this._logId, l2);
                        }
                        byte[] byArray2 = null;
                        if (byArray == null) break block5;
                        byArray2 = new byte[n2];
                        System.arraycopy(byArray, n - 1, byArray2, 0, n2);
                        n4 = this.setBytes(l, byArray2);
                        if (!bl) break block6;
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            LogUtil.logEnd(LOG, null, null, this._logId, "setBytes", "long, byte[], int, int", new Object[]{l, byArray, n, n2}, l2);
                        }
                        throw throwable;
                    }
                    LogUtil.logEnd(LOG, null, null, this._logId, "setBytes", "long, byte[], int, int", new Object[]{l, byArray, n, n2}, l2);
                }
                return n4;
            }
            n3 = 0;
            if (!bl) break block7;
            LogUtil.logEnd(LOG, null, null, this._logId, "setBytes", "long, byte[], int, int", new Object[]{l, byArray, n, n2}, l2);
        }
        return n3;
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        if (l < 1L || l > this.length()) {
            ErrorMessage.raiseError("JZ037");
        }
        return new BufferedOutputStream(new LobLocatorOutputStream(this, l), 16384);
    }
}

