/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.maxdb.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.maxdb.database.MaxDBDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.RenameTableGenerator;
import liquibase.statement.core.RenameTableStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class RenameTableGeneratorMaxDB
extends RenameTableGenerator {
    public boolean supports(RenameTableStatement statement, Database database) {
        return database instanceof MaxDBDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public Sql[] generateSql(RenameTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String sql = "RENAME TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getOldTableName()) + " TO " + database.escapeObjectName(statement.getNewTableName(), Table.class);
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedOldTable(statement), this.getAffectedNewTable(statement)})};
    }
}

