/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchEventWhenAutoReset
extends TestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(WatchEventWhenAutoReset.class);
    private static final int TIMEOUT = 30000;

    private ZooKeeper createClient(QuorumUtil qu, int id, EventsWatcher watcher) throws IOException {
        String hostPort = "127.0.0.1:" + qu.getPeer((int)id).clientPort;
        ZooKeeper zk = new ZooKeeper(hostPort, 30000, watcher);
        try {
            watcher.waitForConnected(30000L);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (TimeoutException e) {
            WatchEventWhenAutoReset.fail((String)("can not connect to " + hostPort));
        }
        return zk;
    }

    private ZooKeeper createClient(QuorumUtil qu, int id) throws IOException {
        return this.createClient(qu, id, new EventsWatcher());
    }

    @Test
    public void testNodeDataChanged() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        qu.startAll();
        EventsWatcher watcher = new EventsWatcher();
        ZooKeeper zk1 = this.createClient(qu, 1, watcher);
        ZooKeeper zk2 = this.createClient(qu, 2);
        String path = "/test-changed";
        zk1.create(path, new byte[1], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.getData(path, watcher, null);
        qu.shutdown(1);
        zk2.delete(path, -1);
        zk2.create(path, new byte[2], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        qu.start(1);
        watcher.waitForConnected(30000L);
        watcher.assertEvent(30000L, Watcher.Event.EventType.NodeDataChanged);
        zk1.exists(path, watcher);
        qu.shutdown(1);
        zk2.delete(path, -1);
        zk2.create(path, new byte[2], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        qu.start(1);
        watcher.waitForConnected(30000000L);
        watcher.assertEvent(30000L, Watcher.Event.EventType.NodeDataChanged);
        qu.shutdownAll();
    }

    @Test
    public void testNodeCreated() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        qu.startAll();
        EventsWatcher watcher = new EventsWatcher();
        ZooKeeper zk1 = this.createClient(qu, 1, watcher);
        ZooKeeper zk2 = this.createClient(qu, 2);
        String path = "/test1-created";
        zk1.exists(path, watcher);
        qu.shutdown(1);
        zk2.create(path, new byte[2], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        qu.start(1);
        watcher.waitForConnected(30000000L);
        watcher.assertEvent(30000L, Watcher.Event.EventType.NodeCreated);
        qu.shutdownAll();
    }

    @Test
    public void testNodeDeleted() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        qu.startAll();
        EventsWatcher watcher = new EventsWatcher();
        ZooKeeper zk1 = this.createClient(qu, 1, watcher);
        ZooKeeper zk2 = this.createClient(qu, 2);
        String path = "/test-deleted";
        zk1.create(path, new byte[1], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.getData(path, watcher, null);
        qu.shutdown(1);
        zk2.delete(path, -1);
        qu.start(1);
        watcher.waitForConnected(30000000L);
        watcher.assertEvent(30000L, Watcher.Event.EventType.NodeDeleted);
        zk1.create(path, new byte[1], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.exists(path, watcher);
        qu.shutdown(1);
        zk2.delete(path, -1);
        qu.start(1);
        watcher.waitForConnected(30000000L);
        watcher.assertEvent(30000L, Watcher.Event.EventType.NodeDeleted);
        zk1.create(path, new byte[1], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.getChildren(path, watcher);
        qu.shutdown(1);
        zk2.delete(path, -1);
        qu.start(1);
        watcher.waitForConnected(30000000L);
        watcher.assertEvent(30000L, Watcher.Event.EventType.NodeDeleted);
        qu.shutdownAll();
    }

    @Test
    public void testNodeChildrenChanged() throws Exception {
        QuorumUtil qu = new QuorumUtil(1);
        qu.startAll();
        EventsWatcher watcher = new EventsWatcher();
        ZooKeeper zk1 = this.createClient(qu, 1, watcher);
        ZooKeeper zk2 = this.createClient(qu, 2);
        String path = "/test-children-changed";
        zk1.create(path, new byte[1], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk1.getChildren(path, watcher);
        qu.shutdown(1);
        zk2.create(path + "/children-1", new byte[2], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        qu.start(1);
        watcher.waitForConnected(30000000L);
        watcher.assertEvent(30000L, Watcher.Event.EventType.NodeChildrenChanged);
        qu.shutdownAll();
    }

    public static class EventsWatcher
    extends ClientBase.CountdownWatcher {
        private LinkedBlockingQueue<WatchedEvent> dataEvents = new LinkedBlockingQueue();

        public void process(WatchedEvent event) {
            super.process(event);
            try {
                if (event.getType() != Watcher.Event.EventType.None) {
                    this.dataEvents.put(event);
                }
            }
            catch (InterruptedException e) {
                LOG.warn("ignoring interrupt during EventsWatcher process");
            }
        }

        public void assertEvent(long timeout, Watcher.Event.EventType eventType) {
            try {
                WatchedEvent event = this.dataEvents.poll(timeout, TimeUnit.MILLISECONDS);
                Assert.assertNotNull((String)("do not receive a " + (Object)((Object)eventType)), (Object)event);
                Assert.assertEquals((Object)((Object)eventType), (Object)((Object)event.getType()));
            }
            catch (InterruptedException e) {
                LOG.warn("ignoring interrupt during EventsWatcher assertEvent");
            }
        }
    }
}

