/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortForwarder
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(PortForwarder.class);
    private volatile boolean stopped = false;
    private ExecutorService workers = Executors.newCachedThreadPool();
    private ServerSocket serverSocket;
    private final int to;

    public PortForwarder(int from, int to) throws IOException {
        this.to = to;
        this.serverSocket = new ServerSocket(from);
        this.serverSocket.setSoTimeout(30000);
        this.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        block9: while (true) {
            try {
                while (!this.stopped) {
                    Socket sock = null;
                    try {
                        LOG.info("accepting socket local:" + this.serverSocket.getLocalPort() + " to:" + this.to);
                        sock = this.serverSocket.accept();
                        LOG.info("accepted: local:" + sock.getLocalPort() + " from:" + sock.getPort() + " to:" + this.to);
                        Socket target = null;
                        int retry = 10;
                        while (sock.isConnected()) {
                            try {
                                target = new Socket("localhost", this.to);
                                break;
                            }
                            catch (IOException e) {
                                if (retry == 0) {
                                    throw e;
                                }
                                LOG.warn("connection failed, retrying(" + retry + "): local:" + sock.getLocalPort() + " from:" + sock.getPort() + " to:" + this.to, e);
                                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                                --retry;
                            }
                        }
                        LOG.info("connected: local:" + sock.getLocalPort() + " from:" + sock.getPort() + " to:" + this.to);
                        sock.setSoTimeout(30000);
                        target.setSoTimeout(30000);
                        this.workers.execute(new PortForwardWorker(sock, target, sock.getInputStream(), target.getOutputStream()));
                        this.workers.execute(new PortForwardWorker(target, sock, target.getInputStream(), sock.getOutputStream()));
                        continue block9;
                    }
                    catch (SocketTimeoutException e) {
                        LOG.warn("socket timed out local:" + (sock != null ? Integer.valueOf(sock.getLocalPort()) : "") + " from:" + (sock != null ? Integer.valueOf(sock.getPort()) : "") + " to:" + this.to, e);
                    }
                    catch (ConnectException e) {
                        LOG.warn("connection exception local:" + (sock != null ? Integer.valueOf(sock.getLocalPort()) : "") + " from:" + (sock != null ? Integer.valueOf(sock.getPort()) : "") + " to:" + this.to, e);
                        sock.close();
                    }
                    catch (IOException e) {
                        if ("Socket closed".equals(e.getMessage())) continue;
                        LOG.warn("unexpected exception local:" + (sock != null ? Integer.valueOf(sock.getLocalPort()) : "") + " from:" + (sock != null ? Integer.valueOf(sock.getPort()) : "") + " to:" + this.to, e);
                        throw e;
                        return;
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Unexpected exception to:" + this.to, e);
                return;
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted to:" + this.to, e);
                return;
            }
        }
    }

    public void shutdown() throws Exception {
        this.stopped = true;
        this.serverSocket.close();
        this.workers.shutdownNow();
        try {
            if (!this.workers.awaitTermination(5L, TimeUnit.SECONDS)) {
                throw new Exception("Failed to stop forwarding within 5 seconds");
            }
        }
        catch (InterruptedException e) {
            throw new Exception("Failed to stop forwarding");
        }
        this.join();
    }

    private static class PortForwardWorker
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;
        private final Socket toClose;
        private final Socket toClose2;

        PortForwardWorker(Socket toClose, Socket toClose2, InputStream in, OutputStream out) throws IOException {
            this.toClose = toClose;
            this.toClose2 = toClose2;
            this.in = in;
            this.out = out;
        }

        public void run() {
            Thread.currentThread().setName(this.toClose.toString() + "-->" + this.toClose2.toString());
            byte[] buf = new byte[1024];
            try {
                while (true) {
                    block18: {
                        try {
                            int read = this.in.read(buf);
                            if (read <= 0) break block18;
                            try {
                                this.out.write(buf, 0, read);
                            }
                            catch (IOException e) {
                                LOG.warn("exception during write", e);
                                try {
                                    this.toClose.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                try {
                                    this.toClose2.close();
                                }
                                catch (IOException iOException) {}
                                break;
                            }
                        }
                        catch (SocketTimeoutException e) {
                            LOG.error("socket timeout", e);
                        }
                    }
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted", e);
                try {
                    this.toClose.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.toClose2.close();
                }
                catch (IOException iOException) {}
            }
            catch (SocketException e) {
                if (!"Socket closed".equals(e.getMessage())) {
                    LOG.error("Unexpected exception", e);
                }
            }
            catch (IOException e) {
                LOG.error("Unexpected exception", e);
            }
            LOG.info("Shutting down forward for " + this.toClose);
        }
    }
}

