/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.io.StringWriter;
import java.util.List;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hadoop.util.StringUtils;

public class JobProgressUpdate {
    public final double progressedPercentage;
    public final String footerSummary;
    public final long startTimeMillis;
    private final List<String> headers;
    private final List<List<String>> rows;
    public final String status;

    JobProgressUpdate(ProgressMonitor monitor) {
        this(monitor.headers(), monitor.rows(), monitor.footerSummary(), monitor.progressedPercentage(), monitor.startTime(), monitor.executionStatus());
    }

    private JobProgressUpdate(List<String> headers, List<List<String>> rows, String footerSummary, double progressedPercentage, long startTimeMillis, String status) {
        this.progressedPercentage = progressedPercentage;
        this.footerSummary = footerSummary;
        this.startTimeMillis = startTimeMillis;
        this.headers = headers;
        this.rows = rows;
        this.status = status;
    }

    public List<String> headers() {
        return this.headers;
    }

    public List<List<String>> rows() {
        return this.rows;
    }

    public String toString() {
        return "JobProgressUpdate{progressedPercentage=" + this.progressedPercentage + ", footerSummary='" + this.footerSummary + '\'' + ", startTimeMillis=" + this.startTimeMillis + ", headers='" + this.forCollection(this.headers) + '\'' + ", rows='" + this.forNestedCollection(this.rows) + '\'' + ", status='" + this.status + '\'' + '}';
    }

    private String forNestedCollection(List<List<String>> collection) {
        if (collection == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        for (List<String> list : collection) {
            writer.append(this.forCollection(list)).append(" / ");
        }
        return writer.toString();
    }

    private String forCollection(List collection) {
        return collection == null ? "" : StringUtils.join((CharSequence)",", collection);
    }
}

