/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.schshim;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.SchedulerShim;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;

public class FairSchedulerShim
implements SchedulerShim {
    private static final Log LOG = LogFactory.getLog(FairSchedulerShim.class);
    private static final String MR2_JOB_QUEUE_PROPERTY = "mapreduce.job.queuename";

    @Override
    public void refreshDefaultQueue(Configuration conf, String userName) throws IOException {
        QueuePlacementPolicy queuePolicy;
        String requestedQueue = "default";
        final AtomicReference<AllocationConfiguration> allocConf = new AtomicReference<AllocationConfiguration>();
        AllocationFileLoaderService allocsLoader = new AllocationFileLoaderService();
        allocsLoader.init(conf);
        allocsLoader.setReloadListener(new AllocationFileLoaderService.Listener(){

            public void onReload(AllocationConfiguration allocs) {
                allocConf.set(allocs);
            }
        });
        try {
            allocsLoader.reloadAllocations();
        }
        catch (Exception ex) {
            throw new IOException("Failed to load queue allocations", ex);
        }
        if (allocConf.get() == null) {
            allocConf.set(new AllocationConfiguration(conf));
        }
        if ((queuePolicy = ((AllocationConfiguration)allocConf.get()).getPlacementPolicy()) != null && StringUtils.isNotBlank(requestedQueue = queuePolicy.assignAppToQueue(requestedQueue, userName))) {
            LOG.debug("Setting queue name to " + requestedQueue + " for user " + userName);
            conf.set(MR2_JOB_QUEUE_PROPERTY, requestedQueue);
        }
    }
}

