/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.ShutdownHookManager;

public final class FileUtils {
    private static final Log LOG;
    private static final Random random;
    public static final PathFilter HIDDEN_FILES_PATH_FILTER;
    public static final PathFilter STAGING_DIR_PATH_FILTER;
    static BitSet charToEscape;

    public static Path makeQualified(Path path, Configuration conf) throws IOException {
        if (!path.isAbsolute()) {
            return path.makeQualified(FileSystem.get(conf));
        }
        URI fsUri = FileSystem.getDefaultUri(conf);
        URI pathUri = path.toUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme == null) {
            scheme = fsUri.getScheme();
            authority = fsUri.getAuthority();
            if (authority == null) {
                authority = "";
            }
        } else if (authority == null) {
            authority = scheme.equals(fsUri.getScheme()) && fsUri.getAuthority() != null ? fsUri.getAuthority() : "";
        }
        return new Path(scheme, authority, pathUri.getPath());
    }

    private FileUtils() {
    }

    public static String makePartName(List<String> partCols, List<String> vals) {
        return FileUtils.makePartName(partCols, vals, null);
    }

    public static String makePartName(List<String> partCols, List<String> vals, String defaultStr) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < partCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(partCols.get(i).toLowerCase(), defaultStr));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i), defaultStr));
        }
        return name.toString();
    }

    public static String makeDefaultListBucketingDirName(List<String> skewedCols, String name) {
        String defaultDir = FileUtils.escapePathName(name);
        StringBuilder defaultDirPath = new StringBuilder();
        for (int i = 0; i < skewedCols.size(); ++i) {
            if (i > 0) {
                defaultDirPath.append("/");
            }
            defaultDirPath.append(defaultDir);
        }
        String lbDirName = defaultDirPath.toString();
        return lbDirName;
    }

    public static String makeListBucketingDirName(List<String> lbCols, List<String> vals) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < lbCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(lbCols.get(i).toLowerCase()));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i)));
        }
        return name.toString();
    }

    static boolean needsEscaping(char c) {
        return c >= '\u0000' && c < charToEscape.size() && charToEscape.get(c);
    }

    public static String escapePathName(String path) {
        return FileUtils.escapePathName(path, null);
    }

    public static String escapePathName(String path, String defaultPath) {
        if (path == null || path.length() == 0) {
            if (defaultPath == null) {
                return "__HIVE_DEFAULT_PARTITION__";
            }
            return defaultPath;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (FileUtils.needsEscaping(c)) {
                sb.append('%');
                sb.append(String.format("%1$02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.valueOf(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void listStatusRecursively(FileSystem fs, FileStatus fileStatus, List<FileStatus> results) throws IOException {
        if (fileStatus.isDir()) {
            for (FileStatus stat : fs.listStatus(fileStatus.getPath(), HIDDEN_FILES_PATH_FILTER)) {
                FileUtils.listStatusRecursively(fs, stat, results);
            }
        } else {
            results.add(fileStatus);
        }
    }

    public static FileStatus getPathOrParentThatExists(FileSystem fs, Path path) throws IOException {
        FileStatus stat = FileUtils.getFileStatusOrNull(fs, path);
        if (stat != null) {
            return stat;
        }
        Path parentPath = path.getParent();
        return FileUtils.getPathOrParentThatExists(fs, parentPath);
    }

    public static void checkFileAccessWithImpersonation(FileSystem fs, FileStatus stat, FsAction action, String user) throws IOException, AccessControlException, InterruptedException, Exception {
        FileUtils.checkFileAccessWithImpersonation(fs, stat, action, user, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkFileAccessWithImpersonation(final FileSystem fs, final FileStatus stat, final FsAction action, String user, final List<FileStatus> children) throws IOException, AccessControlException, InterruptedException, Exception {
        UserGroupInformation ugi = Utils.getUGI();
        String currentUser = ugi.getShortUserName();
        if (user == null || currentUser.equals(user)) {
            ShimLoader.getHadoopShims().checkFileAccess(fs, stat, action);
            FileUtils.addChildren(fs, stat.getPath(), children);
            return;
        }
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser(user, UserGroupInformation.getLoginUser());
        try {
            proxyUser.doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    FileSystem fsAsUser = FileSystem.get(fs.getUri(), fs.getConf());
                    ShimLoader.getHadoopShims().checkFileAccess(fsAsUser, stat, action);
                    FileUtils.addChildren(fsAsUser, stat.getPath(), children);
                    return null;
                }
            });
        }
        finally {
            FileSystem.closeAllForUGI(proxyUser);
        }
    }

    private static void addChildren(FileSystem fsAsUser, Path path, List<FileStatus> children) throws IOException {
        if (children != null) {
            FileStatus[] listStatus;
            try {
                listStatus = fsAsUser.listStatus(path);
            }
            catch (IOException e) {
                LOG.warn("Unable to list files under " + path + " : " + e);
                throw e;
            }
            children.addAll(Arrays.asList(listStatus));
        }
    }

    public static boolean isActionPermittedForFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, FsAction action) throws Exception {
        return FileUtils.isActionPermittedForFileHierarchy(fs, fileStatus, userName, action, true);
    }

    public static boolean isActionPermittedForFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, FsAction action, boolean recurse) throws Exception {
        boolean isDir = fileStatus.isDir();
        FsAction dirActionNeeded = action;
        if (isDir) {
            dirActionNeeded.and(FsAction.EXECUTE);
        }
        ArrayList<FileStatus> subDirsToCheck = null;
        if (isDir && recurse) {
            subDirsToCheck = new ArrayList<FileStatus>();
        }
        try {
            FileUtils.checkFileAccessWithImpersonation(fs, fileStatus, action, userName, subDirsToCheck);
        }
        catch (AccessControlException err) {
            LOG.warn("Action " + (Object)((Object)action) + " denied on " + fileStatus.getPath() + " for user " + userName);
            return false;
        }
        if (subDirsToCheck == null || subDirsToCheck.isEmpty()) {
            return true;
        }
        for (FileStatus childStatus : subDirsToCheck) {
            if (FileUtils.isActionPermittedForFileHierarchy(fs, childStatus, userName, action, true)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLocalFile(HiveConf conf, String fileName) {
        try {
            return FileUtils.isLocalFile(conf, new URI(fileName));
        }
        catch (URISyntaxException e) {
            LOG.warn("Unable to create URI from " + fileName, e);
            return false;
        }
    }

    public static boolean isLocalFile(HiveConf conf, URI fileUri) {
        try {
            FileSystem fsForFile = FileSystem.get(fileUri, conf);
            return LocalFileSystem.class.isInstance(fsForFile);
        }
        catch (IOException e) {
            LOG.warn("Unable to get FileSystem for " + fileUri, e);
            return false;
        }
    }

    public static boolean isOwnerOfFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName) throws IOException, InterruptedException {
        return FileUtils.isOwnerOfFileHierarchy(fs, fileStatus, userName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOwnerOfFileHierarchy(final FileSystem fs, final FileStatus fileStatus, final String userName, final boolean recurse) throws IOException, InterruptedException {
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUser(userName, UserGroupInformation.getLoginUser());
        try {
            boolean isOwner;
            boolean bl = isOwner = proxyUser.doAs(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    FileSystem fsAsUser = FileSystem.get(fs.getUri(), fs.getConf());
                    return FileUtils.checkIsOwnerOfFileHierarchy(fsAsUser, fileStatus, userName, recurse);
                }
            }).booleanValue();
            return bl;
        }
        finally {
            FileSystem.closeAllForUGI(proxyUser);
        }
    }

    public static boolean checkIsOwnerOfFileHierarchy(FileSystem fs, FileStatus fileStatus, String userName, boolean recurse) throws IOException {
        FileStatus[] childStatuses;
        if (!fileStatus.getOwner().equals(userName)) {
            return false;
        }
        if (!fileStatus.isDir() || !recurse) {
            return true;
        }
        for (FileStatus childStatus : childStatuses = fs.listStatus(fileStatus.getPath())) {
            if (FileUtils.checkIsOwnerOfFileHierarchy(fs, childStatus, userName, true)) continue;
            return false;
        }
        return true;
    }

    public static boolean mkdir(FileSystem fs, Path f, boolean inheritPerms, Configuration conf) throws IOException {
        LOG.info("Creating directory if it doesn't exist: " + f);
        if (!inheritPerms) {
            return fs.mkdirs(f);
        }
        try {
            return fs.getFileStatus(f).isDir();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Path lastExistingParent = f;
            Path firstNonExistentParent = null;
            while (!fs.exists(lastExistingParent)) {
                firstNonExistentParent = lastExistingParent;
                lastExistingParent = lastExistingParent.getParent();
            }
            boolean success = fs.mkdirs(f);
            if (!success) {
                return false;
            }
            HadoopShims shim = ShimLoader.getHadoopShims();
            HadoopShims.HdfsFileStatus fullFileStatus = shim.getFullFileStatus(conf, fs, lastExistingParent);
            try {
                shim.setFullFileStatus(conf, fullFileStatus, fs, firstNonExistentParent, true);
            }
            catch (Exception e) {
                LOG.warn("Error setting permissions of " + firstNonExistentParent, e);
            }
            return true;
        }
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, HiveConf conf) throws IOException {
        return FileUtils.copy(srcFS, src, dstFS, dst, deleteSource, overwrite, conf, ShimLoader.getHadoopShims());
    }

    @VisibleForTesting
    static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, HiveConf conf, HadoopShims shims) throws IOException {
        ContentSummary srcContentSummary;
        boolean copied = false;
        boolean triedDistcp = false;
        if (srcFS.getUri().getScheme().equals("hdfs") && (srcContentSummary = srcFS.getContentSummary(src)).getFileCount() > conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXNUMFILES) && srcContentSummary.getLength() > conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXSIZE)) {
            LOG.info("Source is " + srcContentSummary.getLength() + " bytes. (MAX: " + conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXSIZE) + ")");
            LOG.info("Source is " + srcContentSummary.getFileCount() + " files. (MAX: " + conf.getLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXNUMFILES) + ")");
            LOG.info("Launch distributed copy (distcp) job.");
            triedDistcp = true;
            copied = shims.runDistCp(Collections.singletonList(src), dst, conf);
            if (copied && deleteSource) {
                srcFS.delete(src, true);
            }
        }
        if (!triedDistcp) {
            copied = FileUtil.copy(srcFS, src, dstFS, dst, deleteSource, overwrite, (Configuration)conf);
        }
        boolean inheritPerms = conf.getBoolVar(HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS);
        if (copied && inheritPerms) {
            HadoopShims.HdfsFileStatus fullFileStatus = shims.getFullFileStatus(conf, dstFS, dst);
            try {
                shims.setFullFileStatus(conf, fullFileStatus, dstFS, dst, true);
            }
            catch (Exception e) {
                LOG.warn("Error setting permissions or group of " + dst, e);
            }
        }
        return copied;
    }

    public static boolean distCp(FileSystem srcFS, List<Path> srcPaths, Path dst, boolean deleteSource, String doAsUser, HiveConf conf, HadoopShims shims) throws IOException {
        boolean copied = false;
        copied = doAsUser == null ? shims.runDistCp(srcPaths, dst, conf) : shims.runDistCpAs(srcPaths, dst, conf, doAsUser);
        if (copied && deleteSource) {
            for (Path path : srcPaths) {
                srcFS.delete(path, true);
            }
        }
        return copied;
    }

    public static boolean moveToTrash(FileSystem fs, Path f, Configuration conf) throws IOException {
        LOG.debug("deleting  " + f);
        HadoopShims hadoopShim = ShimLoader.getHadoopShims();
        boolean result = false;
        try {
            result = hadoopShim.moveToAppropriateTrash(fs, f, conf);
            if (result) {
                LOG.trace("Moved to trash: " + f);
                return true;
            }
        }
        catch (IOException ioe) {
            LOG.warn(ioe.getMessage() + "; Force to delete it.");
        }
        result = fs.delete(f, true);
        if (!result) {
            LOG.error("Failed to delete " + f);
        }
        return result;
    }

    public static boolean isSubDir(Path p1, Path p2, FileSystem fs) {
        String path2;
        String path1 = fs.makeQualified(p1).toString();
        return path1.startsWith(path2 = fs.makeQualified(p2).toString());
    }

    public static boolean renameWithPerms(FileSystem fs, Path sourcePath, Path destPath, boolean inheritPerms, Configuration conf) throws IOException {
        LOG.info("Renaming " + sourcePath + " to " + destPath);
        if (!inheritPerms) {
            return fs.rename(sourcePath, destPath);
        }
        if (fs.rename(sourcePath, destPath)) {
            HadoopShims shims = ShimLoader.getHadoopShims();
            HadoopShims.HdfsFileStatus fullFileStatus = shims.getFullFileStatus(conf, fs, destPath.getParent());
            try {
                shims.setFullFileStatus(conf, fullFileStatus, fs, destPath, true);
            }
            catch (Exception e) {
                LOG.warn("Error setting permissions or group of " + destPath, e);
            }
            return true;
        }
        return false;
    }

    public static boolean equalsFileSystem(FileSystem fs1, FileSystem fs2) {
        return fs1.getUri().equals(fs2.getUri());
    }

    public static void checkDeletePermission(Path path, Configuration conf, String user) throws AccessControlException, InterruptedException, Exception {
        if (path == null) {
            return;
        }
        FileSystem fs = path.getFileSystem(conf);
        FileStatus stat = null;
        try {
            stat = fs.getFileStatus(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (stat == null) {
            return;
        }
        FileUtils.checkFileAccessWithImpersonation(fs, stat, FsAction.WRITE, user);
        HadoopShims shims = ShimLoader.getHadoopShims();
        if (!shims.supportStickyBit()) {
            return;
        }
        FileStatus parStatus = fs.getFileStatus(path.getParent());
        if (!shims.hasStickyBit(parStatus.getPermission())) {
            return;
        }
        if (parStatus.getOwner().equals(user)) {
            return;
        }
        FileStatus childStatus = fs.getFileStatus(path);
        if (childStatus.getOwner().equals(user)) {
            return;
        }
        String msg = String.format("Permission Denied: User %s can't delete %s because sticky bit is set on the parent dir and user does not own this file or its parent", user, path);
        throw new IOException(msg);
    }

    public static FileStatus getFileStatusOrNull(FileSystem fs, Path path) throws IOException {
        try {
            return fs.getFileStatus(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static void deleteDirectory(File directory) throws IOException {
        org.apache.commons.io.FileUtils.deleteDirectory((File)directory);
    }

    public static File createTempFile(String lScratchDir, String prefix, String suffix) throws IOException {
        File tmpDir;
        File file = tmpDir = lScratchDir == null ? null : new File(lScratchDir);
        if (!(tmpDir == null || tmpDir.exists() || tmpDir.mkdirs() || tmpDir.exists())) {
            throw new RuntimeException("Unable to create temp directory " + lScratchDir);
        }
        File tmpFile = File.createTempFile(prefix, suffix, tmpDir);
        ShutdownHookManager.deleteOnExit(tmpFile);
        return tmpFile;
    }

    public static File createLocalDirsTempFile(String localDirList, String prefix, String suffix, boolean isDirectory) throws IOException {
        if (localDirList == null || localDirList.isEmpty()) {
            return FileUtils.createFileInTmp(prefix, suffix, "Local directories not specified", isDirectory);
        }
        String[] localDirs = StringUtils.getTrimmedStrings(localDirList);
        if (localDirs.length == 0) {
            return FileUtils.createFileInTmp(prefix, suffix, "Local directories not specified", isDirectory);
        }
        String path = localDirs[random.nextInt(localDirs.length)];
        if (path == null || path.isEmpty()) {
            return FileUtils.createFileInTmp(prefix, suffix, "Empty path for one of the local dirs", isDirectory);
        }
        File targetDir = new File(path);
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            return FileUtils.createFileInTmp(prefix, suffix, "Cannot access or create " + targetDir, isDirectory);
        }
        try {
            File file = File.createTempFile(prefix, suffix, targetDir);
            if (!(!isDirectory || file.delete() && file.mkdirs())) {
                return FileUtils.createFileInTmp(prefix, suffix, "Cannot recreate " + file + " as directory", isDirectory);
            }
            file.deleteOnExit();
            return file;
        }
        catch (IOException ex) {
            LOG.error("Error creating a file in " + targetDir, ex);
            return FileUtils.createFileInTmp(prefix, suffix, "Cannot create a file in " + targetDir, isDirectory);
        }
    }

    private static File createFileInTmp(String prefix, String suffix, String reason, boolean isDirectory) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        if (!(!isDirectory || file.delete() && file.mkdirs())) {
            throw new IOException("Cannot recreate " + file + " as directory");
        }
        file.deleteOnExit();
        LOG.info(reason + "; created a tmp file: " + file.getAbsolutePath());
        return file;
    }

    public static File createLocalDirsTempFile(Configuration conf, String prefix, String suffix, boolean isDirectory) throws IOException {
        return FileUtils.createLocalDirsTempFile(conf.get("yarn.nodemanager.local-dirs"), prefix, suffix, isDirectory);
    }

    public static boolean deleteTmpFile(File tempFile) {
        if (tempFile != null) {
            tempFile.delete();
            ShutdownHookManager.cancelDeleteOnExit(tempFile);
            return true;
        }
        return false;
    }

    public static boolean isPathWithinSubtree(Path path, Path subtree) {
        return FileUtils.isPathWithinSubtree(path, subtree, subtree.depth());
    }

    private static boolean isPathWithinSubtree(Path path, Path subtree, int subtreeDepth) {
        while (path != null) {
            if (subtreeDepth > path.depth()) {
                return false;
            }
            if (subtree.equals(path)) {
                return true;
            }
            path = path.getParent();
        }
        return false;
    }

    static {
        char[] clist;
        LOG = LogFactory.getLog(FileUtils.class.getName());
        random = new Random();
        HIDDEN_FILES_PATH_FILTER = new PathFilter(){

            @Override
            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        };
        STAGING_DIR_PATH_FILTER = new PathFilter(){

            @Override
            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith(".");
            }
        };
        charToEscape = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            charToEscape.set(c);
        }
        for (char c : clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'}) {
            charToEscape.set(c);
        }
        if (Shell.WINDOWS) {
            char[] winClist;
            for (char c : winClist = new char[]{' ', '<', '>', '|'}) {
                charToEscape.set(c);
            }
        }
    }
}

