/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.sqlgenerator;

import java.util.Iterator;
import java.util.LinkedList;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.ValidationErrors;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.statement.CreateTableStatementVertica;
import liquibase.ext.vertica.structure.Segmentation;
import liquibase.logging.LogFactory;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtils;

public class CreateTableGeneratorVertica
extends AbstractSqlGenerator<CreateTableStatementVertica> {
    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(CreateTableStatementVertica statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        validationErrors.checkRequiredField("columns", (Object)statement.getColumns());
        return validationErrors;
    }

    public boolean supports(CreateTableStatementVertica statement, Database database) {
        return database instanceof VerticaDatabase;
    }

    public Sql[] generateSql(CreateTableStatementVertica statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        if (statement.getSchemaName() != null) {
            sql.append(statement.getSchemaName()).append(".");
        } else {
            sql.append(database.getDefaultSchemaName()).append(".");
        }
        if (statement.getTableName() != null) {
            sql.append(statement.getTableName()).append(" ");
        }
        boolean isSinglePrimaryKeyColumn = statement.getPrimaryKeyConstraint() != null && statement.getPrimaryKeyConstraint().getColumns().size() == 1;
        boolean isPrimaryKeyAutoIncrement = false;
        sql.append("( ");
        Iterator columnIterator = statement.getColumns().iterator();
        LinkedList<String> primaryKeyColumns = new LinkedList<String>();
        while (columnIterator.hasNext()) {
            String column = (String)columnIterator.next();
            DatabaseDataType columnType = ((LiquibaseDataType)statement.getColumnTypes().get(column)).toDatabaseDataType(database);
            sql.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), column));
            AutoIncrementConstraint autoIncrementConstraint = null;
            for (AutoIncrementConstraint currentAutoIncrementConstraint : statement.getAutoIncrementConstraints()) {
                if (!column.equals(currentAutoIncrementConstraint.getColumnName())) continue;
                autoIncrementConstraint = currentAutoIncrementConstraint;
                break;
            }
            boolean isAutoIncrementColumn = autoIncrementConstraint != null;
            boolean isPrimaryKeyColumn = statement.getPrimaryKeyConstraint() != null && statement.getPrimaryKeyConstraint().getColumns().contains(column);
            boolean bl = isPrimaryKeyAutoIncrement = isPrimaryKeyAutoIncrement || isPrimaryKeyColumn && isAutoIncrementColumn;
            if (isPrimaryKeyColumn) {
                primaryKeyColumns.add(column);
            }
            if (!isAutoIncrementColumn) {
                sql.append(" ").append(columnType);
            }
            if (!columnType.isAutoIncrement() && statement.getDefaultValue(column) != null) {
                Object defaultValue = statement.getDefaultValue(column);
                sql.append(" DEFAULT ");
                sql.append(((LiquibaseDataType)statement.getColumnTypes().get(column)).objectToSql(defaultValue, database));
            }
            if (isAutoIncrementColumn) {
                if (database.supportsAutoIncrement()) {
                    String autoIncrementClause = database.getAutoIncrementClause(autoIncrementConstraint.getStartWith(), autoIncrementConstraint.getIncrementBy());
                    if (!"".equals(autoIncrementClause)) {
                        sql.append(" ").append(autoIncrementClause);
                    }
                    if (database instanceof PostgresDatabase && autoIncrementConstraint.getStartWith() != null) {
                        String string = statement.getTableName() + "_" + column + "_seq";
                    }
                } else {
                    LogFactory.getLogger().warning(database.getShortName() + " does not support autoincrement columns as request for " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()));
                }
            }
            if (isPrimaryKeyColumn) {
                String pkName = StringUtils.trimToNull((String)statement.getPrimaryKeyConstraint().getConstraintName());
                if (pkName != null) {
                    sql.append(" CONSTRAINT ");
                    sql.append(database.escapeConstraintName(pkName));
                }
                sql.append(" PRIMARY KEY ");
            }
            if (statement.getNotNullColumns().contains(column)) {
                sql.append(" NOT NULL");
            }
            if (statement.getColumnEncoding(column) != null) {
                sql.append(" ENCODING ").append(statement.getColumnEncoding(column));
            }
            if (statement.getColumnAccessrank(column) != null) {
                sql.append(" ACCESSRANK  ").append(statement.getColumnAccessrank(column));
            }
            if (!columnIterator.hasNext()) continue;
            sql.append(", ");
        }
        sql.append(" )");
        if (statement.getOrderby() != null) {
            sql.append(" ORDER BY ").append(statement.getOrderby());
        }
        if (statement.getSegmentation() != null) {
            Segmentation seg = statement.getSegmentation();
            if (seg.getUnsegmented().booleanValue()) {
                sql.append(" UNSEGMENTED ");
            } else {
                sql.append(" SEGMENTED BY ");
                sql.append(seg.getExpression());
            }
            if (seg.getAllNodes().booleanValue()) {
                sql.append(" ALL NODES ");
            } else {
                sql.append(" NODES ").append(seg.getNodes());
                if (seg.getOffset() != null) {
                    sql.append(" OFFSET ").append(seg.getOffset().toString());
                }
            }
        }
        if (statement.getKsafe() != null) {
            sql.append(" KSAFE ").append(statement.getKsafe());
        }
        if (statement.getPartitionby() != null) {
            sql.append(" PARTITION BY ").append(statement.getPartitionby());
        }
        System.out.println(sql.toString());
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

