/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.diff.output.changelog;

import java.util.Date;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.ext.vertica.change.ColumnConfigVertica;
import liquibase.ext.vertica.change.CreateTableChangeVertica;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Table;

public class MissingTableChangeGeneratorVertica
implements MissingObjectChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof VerticaDatabase && Table.class.isAssignableFrom(objectType)) {
            return 5;
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        Table missingTable = (Table)missingObject;
        PrimaryKey primaryKey = missingTable.getPrimaryKey();
        CreateTableChangeVertica change = new CreateTableChangeVertica();
        change.setTableName(missingTable.getName());
        change.setSchemaName(missingTable.getSchema().getName());
        if (missingTable.getRemarks() != null) {
            change.setRemarks(missingTable.getRemarks());
        }
        if (missingTable.getAttribute("partitionby", String.class) != null) {
            change.setPartitionby((String)missingTable.getAttribute("partitionby", String.class));
        }
        for (Column column : missingTable.getColumns()) {
            Object defaultValue;
            ColumnConfigVertica columnConfig = new ColumnConfigVertica();
            columnConfig.setName(column.getName());
            columnConfig.setType(DataTypeFactory.getInstance().from(column.getType(), comparisonDatabase).toDatabaseDataType(referenceDatabase).toString());
            if (column.isAutoIncrement()) {
                columnConfig.setAutoIncrement(true);
            }
            ConstraintsConfig constraintsConfig = null;
            if (primaryKey != null && primaryKey.getColumnNamesAsList().contains(column.getName()) && primaryKey.getColumnNamesAsList().size() == 1) {
                constraintsConfig = new ConstraintsConfig();
                constraintsConfig.setPrimaryKey(Boolean.valueOf(true));
                constraintsConfig.setPrimaryKeyTablespace(primaryKey.getTablespace());
                if (comparisonDatabase instanceof MySQLDatabase && "PRIMARY".equals(primaryKey.getName())) {
                    constraintsConfig.setPrimaryKeyName(null);
                } else {
                    constraintsConfig.setPrimaryKeyName(primaryKey.getName());
                }
                control.setAlreadyHandledMissing((DatabaseObject)primaryKey);
                control.setAlreadyHandledMissing((DatabaseObject)primaryKey.getBackingIndex());
            } else if (column.isNullable() != null && !column.isNullable().booleanValue()) {
                constraintsConfig = new ConstraintsConfig();
                constraintsConfig.setNullable(Boolean.valueOf(false));
            }
            if (constraintsConfig != null) {
                columnConfig.setConstraints(constraintsConfig);
            }
            if ((defaultValue = column.getDefaultValue()) != null && !column.isAutoIncrement()) {
                if (defaultValue instanceof Date) {
                    columnConfig.setDefaultValueDate((Date)defaultValue);
                } else if (defaultValue instanceof Boolean) {
                    columnConfig.setDefaultValueBoolean((Boolean)defaultValue);
                } else if (defaultValue instanceof Number) {
                    columnConfig.setDefaultValueNumeric((Number)defaultValue);
                } else if (defaultValue instanceof DatabaseFunction) {
                    columnConfig.setDefaultValueComputed((DatabaseFunction)defaultValue);
                } else {
                    columnConfig.setDefaultValue(defaultValue.toString());
                }
            }
            if (column.getRemarks() != null) {
                columnConfig.setRemarks(column.getRemarks());
            }
            change.addColumn((ColumnConfig)columnConfig);
            control.setAlreadyHandledMissing((DatabaseObject)column);
        }
        return new Change[]{change};
    }
}

