/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.resultset.document;

import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentRenderer;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.LongKeyMap;

public abstract class TextRenderer
implements IDocumentRenderer {
    public static final String LINE_SEPARATOR = GeneralUtils.getDefaultLineSeparator();
    public static final int MAP_INDENT = 4;
    protected final IDocumentFrame documentFrame;
    private int lineHeight;
    private int charWidth;
    private LongKeyMap<Object> objectCoordMap = new LongKeyMap();
    private Map<Object, Boolean> collapsedObjects = new IdentityHashMap<Object, Boolean>();

    protected TextRenderer(IDocumentFrame documentFrame) {
        this.documentFrame = documentFrame;
    }

    @Override
    public Point computeSize(GC gc) {
        Font font = this.documentFrame.getCanvas().getFont();
        Font oldFont = gc.getFont();
        gc.setFont(font);
        FontMetrics fontMetrics = gc.getFontMetrics();
        this.lineHeight = fontMetrics.getHeight();
        this.charWidth = fontMetrics.getAverageCharWidth();
        gc.setFont(oldFont);
        this.objectCoordMap.clear();
        TextMeasurer measurer = new TextMeasurer();
        this.renderNode(measurer, this.documentFrame.getDocument().getRootNode(), 0, 0);
        return new Point(measurer.maxX * this.charWidth, (measurer.maxY + 1) * this.lineHeight);
    }

    @Override
    public int getLineHeight() {
        return this.lineHeight;
    }

    @Override
    public int getCharWidth() {
        return this.charWidth;
    }

    @Override
    public void paintDocument(@NotNull GC gc, @NotNull Canvas canvas, @NotNull Rectangle bounds) {
        TextPainter textProcessor = new TextPainter(gc, bounds, canvas);
        this.renderNode(textProcessor, this.documentFrame.getDocument().getRootNode(), 0, 0);
    }

    @Override
    public void getContents(@NotNull StringBuilder buf, @NotNull IDocumentFrame state, @NotNull DBDDisplayFormat format) {
        TextCopier textCopier = new TextCopier(buf, state);
        textCopier.measureMode = true;
        this.renderNode(textCopier, this.documentFrame.getDocument().getRootNode(), 0, 0);
        textCopier.measureMode = false;
        this.renderNode(textCopier, this.documentFrame.getDocument().getRootNode(), 0, 0);
    }

    @Override
    public boolean handleMouseDown(MouseEvent event, Point position) {
        long nodeId = TextRenderer.getNodeId(position.x, position.y);
        Object object = this.objectCoordMap.get(nodeId);
        if (object != null) {
            if (this.collapsedObjects.remove(object) == null) {
                this.collapsedObjects.put(object, Boolean.TRUE);
            }
            return true;
        }
        return false;
    }

    @Override
    public void createEditor(@NotNull Canvas canvas, @NotNull Rectangle bounds) {
    }

    @Override
    public void dispose() {
    }

    protected abstract void renderNode(TextProcessor var1, Object var2, int var3, int var4);

    protected boolean isNodeCollapsed(Object node) {
        return this.collapsedObjects.get(node) != null;
    }

    private static long getNodeId(int x, int y) {
        return (long)y * 1000000000L | (long)x;
    }

    public static enum NodeState {
        collapsed((DBPImage)UIIcon.TREE_EXPAND),
        expanded((DBPImage)UIIcon.TREE_COLLAPSE);

        private final DBPImage image;

        private NodeState(DBPImage image) {
            this.image = image;
        }

        @NotNull
        public DBPImage getImage() {
            return this.image;
        }
    }

    class TextCopier
    implements TextProcessor {
        @NotNull
        private final IDocumentFrame state;
        @NotNull
        private final StringBuilder content;
        private int prevY = -1;
        private int prevX = -1;
        private int minX = -1;
        private boolean measureMode = false;

        TextCopier(@NotNull StringBuilder content, IDocumentFrame state) {
            this.content = content;
            this.state = state;
        }

        @Override
        public boolean isOutOfRange(int y) {
            return false;
        }

        @Override
        public void drawText(String text, int x, int y, Color color) {
            Point selectionStart = this.state.getSelectionStart();
            Point selectionEnd = this.state.getSelectionEnd();
            if (selectionStart != null && selectionEnd != null && !selectionEnd.equals((Object)selectionStart)) {
                Point startPos = selectionStart.y < selectionEnd.y || selectionStart.y == selectionEnd.y && selectionStart.x < selectionEnd.x ? selectionStart : selectionEnd;
                Point endPos = startPos == selectionStart ? selectionEnd : selectionStart;
                int textLength = text.length();
                if ((y > startPos.y || y == startPos.y && (startPos.x < x || x + textLength > startPos.x)) && (y < endPos.y || y == endPos.y && x < endPos.x)) {
                    int textStart = 0;
                    int textEnd = textLength;
                    if (y == startPos.y && x < startPos.x && x + textLength > startPos.x) {
                        textStart = startPos.x - x;
                    }
                    if (y == endPos.y && x < endPos.x & x + textLength > endPos.x) {
                        textEnd = endPos.x - x;
                    }
                    this.printText(text, textStart, textEnd, x, y);
                }
            } else {
                this.printText(text, 0, text.length(), x, y);
            }
        }

        private void printText(String text, int textStart, int textEnd, int x, int y) {
            if (this.measureMode) {
                this.minX = this.minX == -1 ? x : Math.min(this.minX, x);
            } else {
                int i;
                if (this.prevY != -1 && y > this.prevY) {
                    i = this.prevY;
                    while (i < y) {
                        this.content.append(LINE_SEPARATOR);
                        ++i;
                    }
                }
                if (y > this.prevY) {
                    i = this.minX;
                    while (i < x) {
                        this.content.append(' ');
                        ++i;
                    }
                }
                this.content.append(text, textStart, textEnd);
                this.prevY = y;
            }
        }

        @Override
        public void drawState(Object node, NodeState state, int x, int y) {
        }
    }

    class TextMeasurer
    implements TextProcessor {
        private int maxY = 0;
        private int maxX = 0;

        TextMeasurer() {
        }

        @Override
        public boolean isOutOfRange(int y) {
            return false;
        }

        @Override
        public void drawText(String text, int x, int y, Color color) {
            this.maxX = Math.max(this.maxX, x + text.length());
            this.maxY = Math.max(this.maxY, y);
        }

        @Override
        public void drawState(Object node, NodeState state, int x, int y) {
            if (state == NodeState.collapsed) {
                TextRenderer.this.collapsedObjects.put(node, Boolean.TRUE);
            } else {
                TextRenderer.this.collapsedObjects.remove(node);
            }
            TextRenderer.this.objectCoordMap.put(TextRenderer.getNodeId(x, y), node);
        }
    }

    class TextPainter
    implements TextProcessor {
        private final GC gc;
        private final Rectangle bounds;
        private final int bottomY;
        private Color selectionFG;
        private Color selectionBG;

        TextPainter(GC gc, Rectangle bounds, Canvas canvas) {
            this.gc = gc;
            this.bounds = bounds;
            this.bottomY = canvas.getSize().y;
            this.selectionFG = gc.getDevice().getSystemColor(25);
            this.selectionBG = gc.getDevice().getSystemColor(26);
        }

        @Override
        public boolean isOutOfRange(int y) {
            return this.bounds.y + y * TextRenderer.this.lineHeight > this.bottomY;
        }

        @Override
        public void drawText(String text, int x, int y, Color color) {
            if (this.bounds.y + y * TextRenderer.this.lineHeight < -TextRenderer.this.lineHeight) {
                return;
            }
            if (color != null) {
                this.gc.setForeground(color);
            }
            if (TextRenderer.this.documentFrame.isSelected()) {
                Point selectionStart = TextRenderer.this.documentFrame.getSelectionStart();
                Point selectionEnd = TextRenderer.this.documentFrame.getSelectionEnd();
                if (selectionStart != null && selectionEnd != null && selectionEnd != selectionStart) {
                    Point startPos = selectionStart.y < selectionEnd.y || selectionStart.y == selectionEnd.y && selectionStart.x < selectionEnd.x ? selectionStart : selectionEnd;
                    Point endPos = startPos == selectionStart ? selectionEnd : selectionStart;
                    int textLength = text.length();
                    if ((y > startPos.y || y == startPos.y && (startPos.x < x || x + textLength > startPos.x)) && (y < endPos.y || y == endPos.y && x < endPos.x)) {
                        String head = null;
                        String tail = null;
                        if (y == startPos.y && x < startPos.x && x + textLength > startPos.x) {
                            head = text.substring(0, startPos.x - x);
                        }
                        if (y == endPos.y && x < endPos.x & x + textLength > endPos.x) {
                            tail = text.substring(endPos.x - x);
                        }
                        if (head != null || tail != null) {
                            int textStart = head == null ? 0 : head.length();
                            int textEnd = tail == null ? textLength : textLength - tail.length();
                            text = text.substring(textStart, textEnd);
                        }
                        if (head != null && !head.isEmpty()) {
                            x = this.drawText(head, x, y, true);
                        }
                        if (!text.isEmpty()) {
                            this.gc.setBackground(this.selectionBG);
                            this.gc.setForeground(this.selectionFG);
                            x = this.drawText(text, x, y, false);
                            this.gc.setForeground(color);
                        }
                        if (tail != null && !tail.isEmpty()) {
                            this.drawText(tail, x, y, true);
                        }
                        return;
                    }
                }
            }
            this.drawText(text, x, y, true);
        }

        private int drawText(String text, int x, int y, boolean transparent) {
            if (this.gc.getDevice().isAutoScalable()) {
                int i = 0;
                while (i < text.length()) {
                    this.gc.drawText(String.valueOf(text.charAt(i)), this.bounds.x + x * TextRenderer.this.charWidth, this.bounds.y + y * TextRenderer.this.lineHeight, transparent);
                    ++x;
                    ++i;
                }
            } else {
                this.gc.drawText(text, this.bounds.x + x * TextRenderer.this.charWidth, this.bounds.y + y * TextRenderer.this.lineHeight, transparent);
                x += text.length();
            }
            return x;
        }

        @Override
        public void drawState(Object node, NodeState state, int x, int y) {
            if (state.getImage() != null && this.bounds.y + y * TextRenderer.this.lineHeight >= -TextRenderer.this.lineHeight) {
                Image image = DBeaverIcons.getImage((DBPImage)state.getImage());
                Rectangle imageSize = image.getBounds();
                this.gc.drawImage(image, this.bounds.x + x * TextRenderer.this.charWidth, this.bounds.y + y * TextRenderer.this.lineHeight + (TextRenderer.this.lineHeight - imageSize.height) / 2);
            }
        }
    }

    protected static interface TextProcessor {
        public boolean isOutOfRange(int var1);

        public void drawText(String var1, int var2, int var3, Color var4);

        public void drawState(Object var1, NodeState var2, int var3, int var4);
    }
}

