/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.lm;

import com.dbeaver.ee.runtime.internal.ui.UiMessages;
import com.dbeaver.ee.runtime.lm.DBeaverEnterpriseLM;
import com.dbeaver.lm.ui.LicenseImportDialog;
import com.dbeaver.lm.ui.LicenseInfoDialog;
import com.dbeaver.lm.ui.LicenseManagementDialog;
import com.dbeaver.lm.ui.LicenseMissingDialog;
import com.dbeaver.lm.ui.LicenseRenewsDialog;
import com.dbeaver.lm.ui.LicenseTrialDialog;
import com.dbeaver.lm.ui.LicenseUIUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMValidateException;

public class LicenseManagerUIUtils {
    public static LMLicense checkLicense(IProgressMonitor monitor, Shell shell) {
        return LicenseManagerUIUtils.checkLicense(monitor, shell, DBeaverEnterpriseLM.LICENSE_MANAGER, DBeaverEnterpriseLM.EE_PRODUCT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LMLicense checkLicense(IProgressMonitor monitor, Shell shell, LMLicenseManager licenseManager, LMProduct product) {
        LMLicense currentLicense;
        boolean showDialog = false;
        while (true) {
            try {
                currentLicense = licenseManager.getValidProductLicense(monitor, LicenseUIUtils.getClientId(), product, true);
                if (currentLicense != null) {
                    break;
                }
            }
            catch (LMValidateException lMValidateException) {}
            if (LMLicenseManager.getLicenseCustomPath() != null) {
                DBWorkbench.getPlatformUI().showError(UiMessages.DBeaverEnterpriseUI_license_info_title, "No valid license found in " + LMLicenseManager.getLicenseCustomPath().getName());
                return null;
            }
            LicenseMissingDialog dialog = new LicenseMissingDialog(shell, licenseManager, product);
            int choice = dialog.open();
            try {
                switch (choice) {
                    case 1: {
                        return null;
                    }
                    case 1000: {
                        if (!LicenseManagerUIUtils.importLicense(shell)) break;
                        UIUtils.showMessageBox((Shell)shell, (String)UiMessages.DBeaverEnterpriseUI_license_accepted_title, (String)UiMessages.DBeaverEnterpriseUI_license_accepted_message, (int)2);
                        break;
                    }
                    case 1001: {
                        if (!LicenseManagerUIUtils.createTrialLicense(shell)) break;
                        UIUtils.showMessageBox((Shell)shell, (String)UiMessages.DBeaverEnterpriseUI_trial_accepted_title, (String)UiMessages.DBeaverEnterpriseUI_trial_accepted_message, (int)2);
                        break;
                    }
                    case 1002: {
                        LicenseManagementDialog lmDialog = new LicenseManagementDialog(shell, licenseManager, product);
                        lmDialog.open();
                    }
                }
            }
            catch (Throwable e) {
                DBWorkbench.getPlatformUI().showError(UiMessages.DBeaverEnterpriseUI_e_lm_internal_title, UiMessages.DBeaverEnterpriseUI_e_lm_internal_message, e);
            }
            showDialog = true;
        }
        if (showDialog) {
            LicenseManagerUIUtils.showLicenseInfoDialog();
        }
        LicenseManagerUIUtils.showLicenseExpireNotify(licenseManager, product, currentLicense);
        return currentLicense;
    }

    private static boolean createTrialLicense(Shell shell) {
        LicenseTrialDialog trialDialog = new LicenseTrialDialog(shell, DBeaverEnterpriseLM.LICENSE_MANAGER, DBeaverEnterpriseLM.EE_PRODUCT);
        int choice = trialDialog.open();
        return choice == 0;
    }

    private static boolean importLicense(Shell shell) {
        LicenseImportDialog importDialog = new LicenseImportDialog(shell, DBeaverEnterpriseLM.LICENSE_MANAGER, DBeaverEnterpriseLM.EE_PRODUCT);
        int choice = importDialog.open();
        return choice == 0;
    }

    public static void showLicenseInfoDialog() {
        try {
            LicenseInfoDialog dialog = new LicenseInfoDialog(UIUtils.getActiveWorkbenchShell(), DBeaverEnterpriseLM.LICENSE_MANAGER, DBeaverEnterpriseLM.EE_PRODUCT);
            dialog.open();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError(UiMessages.DBeaverEnterpriseUI_license_info_title, UiMessages.DBeaverEnterpriseUI_license_info_message, (Throwable)e);
        }
    }

    private static void showLicenseExpireNotify(LMLicenseManager licenseManager, LMProduct product, LMLicense license) {
        String productVersionId = String.valueOf(product.getId()) + "-" + GeneralUtils.getMajorVersion();
        if (LicenseRenewsDialog.isSuppressedFor((String)productVersionId)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        boolean renewChosen = false;
        if (license.getLicenseEndTime() != null) {
            LocalDateTime licenseEndTime = license.getLicenseEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (licenseEndTime.isBefore(now)) {
                return;
            }
            long daysBeforeEnd = ChronoUnit.DAYS.between(licenseEndTime, now);
            if (license.isSubscription()) {
                if (daysBeforeEnd == 1L) {
                    LicenseRenewsDialog renewDialog = new LicenseRenewsDialog(UIUtils.getActiveWorkbenchShell(), "Extend your subscription", "Your subscription will expire after " + daysBeforeEnd + " day(s)." + ".\nWould you like to continue to use DBeaver?", productVersionId, license);
                    renewChosen = renewDialog.open() == 0;
                }
            } else if (daysBeforeEnd == 14L || daysBeforeEnd == 7L || daysBeforeEnd == 1L) {
                LicenseRenewsDialog renewDialog = new LicenseRenewsDialog(UIUtils.getActiveWorkbenchShell(), "Extend your license", "Your license will expire at " + licenseEndTime.toLocalDate() + ".\nWould you like to continue to use DBeaver?", productVersionId, license);
                renewChosen = renewDialog.open() == 0;
            }
        } else {
            long daysAfterEnd;
            LocalDateTime supportEndTime = license.getSupportEndDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (supportEndTime.isBefore(now) && ((daysAfterEnd = ChronoUnit.DAYS.between(supportEndTime, now)) == 1L || daysAfterEnd == 7L || daysAfterEnd == 14L)) {
                LicenseRenewsDialog renewDialog = new LicenseRenewsDialog(UIUtils.getActiveWorkbenchShell(), "Extend your license", "Free DBeaver version upgrade was ended at " + supportEndTime.toLocalDate() + ".\n\nIt is just a reminder that you can renew your license with discount till " + supportEndTime.plusMonths(1L).toLocalDate(), productVersionId, license);
                boolean bl = renewChosen = renewDialog.open() == 0;
            }
        }
        if (renewChosen) {
            LicenseManagementDialog lmDialog = new LicenseManagementDialog(UIUtils.getActiveWorkbenchShell(), licenseManager, product);
            lmDialog.open();
        }
    }
}

