/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import nl.knaw.dans.common.dbflib.CharacterFormatValidator;
import nl.knaw.dans.common.dbflib.DataValidator;
import nl.knaw.dans.common.dbflib.DateFormatValidator;
import nl.knaw.dans.common.dbflib.DbfLibException;
import nl.knaw.dans.common.dbflib.Field;
import nl.knaw.dans.common.dbflib.LogicalFormatValidator;
import nl.knaw.dans.common.dbflib.MemoFormatValidator;
import nl.knaw.dans.common.dbflib.NumberFormatValidator;

class DataFormatValidatorFactory {
    static final DataValidator doNothingValidator = new DataValidator(){

        @Override
        public void validate(Object typedObject) throws DbfLibException {
        }
    };

    DataFormatValidatorFactory() {
    }

    static DataValidator createValidator(Field field) {
        switch (field.getType()) {
            case BINARY: 
            case GENERAL: {
                return doNothingValidator;
            }
            case CHARACTER: {
                return new CharacterFormatValidator(field);
            }
            case DATE: {
                return new DateFormatValidator(field);
            }
            case FLOAT: 
            case NUMBER: {
                return new NumberFormatValidator(field);
            }
            case LOGICAL: {
                return new LogicalFormatValidator(field);
            }
            case MEMO: {
                return new MemoFormatValidator(field);
            }
        }
        assert (false) : "Programming error: Not all Types handled";
        return null;
    }
}

