/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Session;
import com.dbeaver.ee.cassandra.exec.CasSession;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.utils.CommonUtils;

public class CasExecutionContext
extends AbstractExecutionContext<CasDataSource> {
    private static final Log log = Log.getLog(CasExecutionContext.class);
    private Session session;
    private ConsistencyLevel currentConsistencyLevel = ConsistencyLevel.ONE;

    public CasExecutionContext(CasDataSource dataSource, String purpose) {
        super((DBPDataSource)dataSource, purpose);
    }

    public Session getSession() {
        return this.session;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((CasDataSource)this.dataSource).getContainer());
        try {
            try {
                monitor.subTask("Open cluster session");
                this.reconnect();
                this.initContextBootstrap(monitor, true);
                ((CasDataSource)this.dataSource).allContexts.add(this);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, this.dataSource);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((CasDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public CasSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new CasSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return true;
    }

    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor monitor, boolean closeOnFailure) throws DBException {
        return DBCExecutionContext.InvalidateResult.ALIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CasExecutionContext casExecutionContext = this;
        synchronized (casExecutionContext) {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            super.closeContext();
        }
        ((CasDataSource)this.dataSource).allContexts.add(this);
    }

    public void reconnect() {
        String keyspaceName;
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        this.session = CommonUtils.isEmpty((String)(keyspaceName = ((CasDataSource)this.dataSource).getSelectedKeyspaceName())) ? ((CasDataSource)this.dataSource).getCluster().connect() : ((CasDataSource)this.dataSource).getCluster().connect(keyspaceName);
        String defCL = ((CasDataSource)this.dataSource).getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-default.consistency.level@");
        if (!CommonUtils.isEmpty((String)defCL)) {
            try {
                this.currentConsistencyLevel = ConsistencyLevel.valueOf((String)defCL);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.debug((Object)("Bad default consistency level: " + defCL));
            }
        }
    }

    public ConsistencyLevel getCurrentConsistencyLevel() {
        return this.currentConsistencyLevel;
    }

    public void setCurrentConsistencyLevel(ConsistencyLevel currentConsistencyLevel) {
        this.currentConsistencyLevel = currentConsistencyLevel;
    }
}

