/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.settransaction;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.settransaction.SetTransactionStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class SetTransactionGenerator
extends AbstractSqlGenerator<SetTransactionStatement> {
    public boolean supports(SetTransactionStatement setTransactionStatement, Database database) {
        return database instanceof OracleDatabase;
    }

    public ValidationErrors validate(SetTransactionStatement setTransactionStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkDisallowedField("rollbackSegment", (Object)setTransactionStatement.getRollbackSegment(), database, new Class[0]);
        validationErrors.checkDisallowedField("isolationLevel", (Object)setTransactionStatement.getIsolationLevel(), database, new Class[0]);
        validationErrors.checkDisallowedField("readOnlyWrite", (Object)setTransactionStatement.getReadOnlyWrite(), database, new Class[0]);
        return validationErrors;
    }

    public Sql[] generateSql(SetTransactionStatement setTransactionStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder();
        sql.append("SET TRANSACTION ");
        if (setTransactionStatement.getIsolationLevel() != null) {
            if (setTransactionStatement.getReadOnlyWrite() != null || setTransactionStatement.getRollbackSegment() != null) {
                // empty if block
            }
            sql.append("ISOLATION LEVEL ").append(setTransactionStatement.getIsolationLevel()).append(" ");
        } else if (setTransactionStatement.getRollbackSegment() != null) {
            if (setTransactionStatement.getReadOnlyWrite() != null) {
                // empty if block
            }
            sql.append("USE ROLLBACK SEGMENT ").append(setTransactionStatement.getRollbackSegment()).append(" ");
        } else if (setTransactionStatement.getReadOnlyWrite() != null) {
            sql.append("READ ").append(setTransactionStatement.getReadOnlyWrite()).append(" ");
        }
        if (setTransactionStatement.getTransactionName() != null) {
            sql.append("NAME '").append(setTransactionStatement.getTransactionName()).append("'");
        }
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

