/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.enabletrigger;

import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.disabletrigger.DisableTriggerChange;
import liquibase.ext.ora.enabletrigger.EnableTriggerStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="enableTrigger", description="Enable Trigger", priority=1)
public class EnableTriggerChange
extends AbstractChange {
    private String schemaName;
    private String triggerName;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getConfirmationMessage() {
        return "Trigger has been enabled.";
    }

    protected Change[] createInverses() {
        DisableTriggerChange inverse = new DisableTriggerChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTriggerName(this.getTriggerName());
        return new Change[]{inverse};
    }

    public SqlStatement[] generateStatements(Database database) {
        EnableTriggerStatement statement = new EnableTriggerStatement(this.getSchemaName(), this.getTriggerName());
        return new SqlStatement[]{statement};
    }
}

