/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createSynonym;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.createSynonym.CreateSynonymStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class CreateSynonymGenerator
extends AbstractSqlGenerator<CreateSynonymStatement> {
    public boolean supports(CreateSynonymStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public ValidationErrors validate(CreateSynonymStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("objectName", (Object)statement.getObjectName());
        validationErrors.checkRequiredField("synonymName", (Object)statement.getSynonymName());
        return validationErrors;
    }

    public Sql[] generateSql(CreateSynonymStatement statement, Database database, SqlGeneratorChain chain) {
        StringBuilder sql = new StringBuilder("CREATE ");
        if (statement.isReplace() != null && statement.isReplace().booleanValue()) {
            sql.append("OR REPLACE ");
        }
        if (statement.isPublic() != null && statement.isPublic().booleanValue()) {
            sql.append("PUBLIC ");
        }
        sql.append("SYNONYM ");
        if (statement.getSynonymSchemaName() != null) {
            sql.append(statement.getSynonymSchemaName()).append(".");
        }
        sql.append(statement.getSynonymName());
        sql.append(" FOR ");
        if (statement.getObjectSchemaName() != null) {
            sql.append(statement.getObjectSchemaName()).append(".");
        }
        sql.append(statement.getObjectName());
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

