/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.adddeferredprimarykey;

import java.util.Iterator;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.adddeferredprimarykey.AddDeferredPrimaryKeyStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class AddDeferredPrimaryKeyGenerator
extends AbstractSqlGenerator<AddDeferredPrimaryKeyStatement> {
    public Sql[] generateSql(AddDeferredPrimaryKeyStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Iterator i$;
        ValidationErrors validationError = this.validate(statement, database, sqlGeneratorChain);
        if (validationError.hasErrors() && (i$ = validationError.getErrorMessages().iterator()).hasNext()) {
            String errorMassage = (String)i$.next();
            throw new IllegalStateException(errorMassage);
        }
        String sql = statement.getConstraintName() == null ? "ALTER TABLE " + database.escapeTableName(null, statement.getSchemaName(), statement.getTableName()) + " ADD PRIMARY KEY (" + database.escapeColumnNameList(statement.getColumnNames()) + ")" : "ALTER TABLE " + database.escapeTableName(null, statement.getSchemaName(), statement.getTableName()) + " ADD CONSTRAINT " + database.escapeConstraintName(statement.getConstraintName()) + " PRIMARY KEY (" + database.escapeColumnNameList(statement.getColumnNames()) + ")";
        if (statement.getDeferrable() != null && statement.getDeferrable().booleanValue()) {
            sql = sql + " DEFERRABLE";
        }
        if (statement.getInitiallyDeferred() != null && statement.getInitiallyDeferred().booleanValue()) {
            sql = sql + " INITIALLY DEFERRED";
        }
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
    }

    public boolean supports(AddDeferredPrimaryKeyStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public ValidationErrors validate(AddDeferredPrimaryKeyStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (!database.supportsInitiallyDeferrableColumns()) {
            validationErrors.checkDisallowedField("initiallyDeferred", (Object)statement.getInitiallyDeferred(), database, new Class[0]);
            validationErrors.checkDisallowedField("deferrable", (Object)statement.getDeferrable(), database, new Class[0]);
        }
        validationErrors.checkRequiredField("columnNames", (Object)statement.getColumnNames());
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        return validationErrors;
    }
}

