/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.struct;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;

public abstract class AbstractTable<DATASOURCE extends DBPDataSource, CONTAINER extends DBSObject>
implements DBSTable {
    private CONTAINER container;
    private String tableName;

    protected AbstractTable(CONTAINER container) {
        this.container = container;
        this.tableName = "";
    }

    protected AbstractTable(CONTAINER container, DBSEntity source) {
        this(container);
        this.tableName = source.getName();
    }

    protected AbstractTable(CONTAINER container, String tableName) {
        this(container);
        this.tableName = tableName;
    }

    public CONTAINER getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    public DBSEntityType getEntityType() {
        return this.isView() ? DBSEntityType.VIEW : DBSEntityType.TABLE;
    }

    @Override
    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.tableName;
    }

    public void setName(String tableName) {
        this.tableName = tableName;
    }

    @NotNull
    public DATASOURCE getDataSource() {
        return (DATASOURCE)this.container.getDataSource();
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    public CONTAINER getParentObject() {
        return this.container;
    }

    public String toString() {
        return this.getFullyQualifiedName(DBPEvaluationContext.UI);
    }
}

