/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.w3c.dom.Document;

public class DBDDocumentXML
implements DBDDocument {
    private Document document;
    private boolean modified;

    public DBDDocumentXML(Document document) {
        this.document = document;
    }

    @Override
    @Nullable
    public Object getDocumentProperty(String name) {
        if ("id".equals(name)) {
            return this.document.getDocumentURI();
        }
        return null;
    }

    @Override
    @NotNull
    public String getDocumentContentType() {
        return "text/xml";
    }

    @Override
    @NotNull
    public Object getRootNode() {
        return this.document.getDocumentElement();
    }

    @Override
    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull OutputStream stream, Charset charset) throws DBException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult output = new StreamResult(new OutputStreamWriter(stream, charset));
            transformer.transform(new DOMSource(this.document), output);
        }
        catch (Exception e) {
            throw new DBException("Error serializing XML document", e);
        }
    }

    @Override
    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull InputStream stream, Charset charset) throws DBException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMResult output = new DOMResult();
            transformer.transform(new StreamSource(new InputStreamReader(stream, charset)), output);
            this.document = (Document)output.getNode();
            this.modified = true;
        }
        catch (Exception e) {
            throw new DBException("Error transforming XML document", e);
        }
    }

    @Override
    public Object getRawValue() {
        return this.document;
    }

    @Override
    public boolean isNull() {
        return this.document == null;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void release() {
        this.document = null;
    }
}

