/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import org.eclipse.core.resources.IFile;

class DataSourceOrigin {
    private final IFile sourceFile;
    private final boolean isDefault;
    private final String configSuffix;

    public DataSourceOrigin(IFile sourceFile, boolean isDefault) {
        this.sourceFile = sourceFile;
        this.isDefault = isDefault;
        if (isDefault) {
            this.configSuffix = "";
        } else {
            String configFileName = sourceFile.getName();
            this.configSuffix = configFileName.substring("data-sources".length(), configFileName.length() - ".json".length());
        }
    }

    public String getName() {
        return this.sourceFile.getName();
    }

    public String getConfigSuffix() {
        return this.configSuffix;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public IFile getSourceFile() {
        return this.sourceFile;
    }

    public String toString() {
        return this.sourceFile.getFullPath().toString();
    }
}

