/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.internal.RowSetUtil;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.Nonnull;

public final class Query
implements Serializable {
    private static final long serialVersionUID = -316972783499434755L;
    private final String tableId;
    private transient ReadRowsRequest.Builder builder = ReadRowsRequest.newBuilder();

    public static Query create(String tableId) {
        return new Query(tableId);
    }

    private Query(String tableId) {
        this.tableId = tableId;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (ReadRowsRequest.Builder)ReadRowsRequest.newBuilder().mergeFrom((InputStream)input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo((OutputStream)output);
    }

    public Query rowKey(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key can't be null.");
        return this.rowKey(ByteString.copyFromUtf8((String)key));
    }

    public Query rowKey(ByteString key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key can't be null.");
        this.builder.getRowsBuilder().addRowKeys(key);
        return this;
    }

    public Query prefix(ByteString prefix) {
        return this.range(Range.ByteStringRange.prefix(prefix));
    }

    public Query prefix(String prefix) {
        return this.range(Range.ByteStringRange.prefix(prefix));
    }

    public Query range(String start, String end) {
        return this.range(Query.wrapKey(start), Query.wrapKey(end));
    }

    public Query range(ByteString start, ByteString end) {
        RowRange.Builder rangeBuilder = RowRange.newBuilder();
        if (start != null) {
            rangeBuilder.setStartKeyClosed(start);
        }
        if (end != null) {
            rangeBuilder.setEndKeyOpen(end);
        }
        this.builder.getRowsBuilder().addRowRanges(rangeBuilder.build());
        return this;
    }

    public Query range(Range.ByteStringRange range) {
        RowRange.Builder rangeBuilder = RowRange.newBuilder();
        switch (range.getStartBound()) {
            case OPEN: {
                rangeBuilder.setStartKeyOpen((ByteString)range.getStart());
                break;
            }
            case CLOSED: {
                rangeBuilder.setStartKeyClosed((ByteString)range.getStart());
                break;
            }
            case UNBOUNDED: {
                rangeBuilder.clearStartKey();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown start bound: " + (Object)((Object)range.getStartBound()));
            }
        }
        switch (range.getEndBound()) {
            case OPEN: {
                rangeBuilder.setEndKeyOpen((ByteString)range.getEnd());
                break;
            }
            case CLOSED: {
                rangeBuilder.setEndKeyClosed((ByteString)range.getEnd());
                break;
            }
            case UNBOUNDED: {
                rangeBuilder.clearEndKey();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown end bound: " + (Object)((Object)range.getEndBound()));
            }
        }
        this.builder.getRowsBuilder().addRowRanges(rangeBuilder.build());
        return this;
    }

    public Query filter(Filters.Filter filter) {
        this.builder.setFilter(filter.toProto());
        return this;
    }

    public Query limit(long limit) {
        Preconditions.checkArgument((limit > 0L ? 1 : 0) != 0, (Object)"Limit must be greater than 0.");
        this.builder.setRowsLimit(limit);
        return this;
    }

    public List<Query> shard(List<KeyOffset> sampledRowKeys) {
        Preconditions.checkState((this.builder.getRowsLimit() == 0L ? 1 : 0) != 0, (Object)"Can't shard query with row limits");
        ImmutableSortedSet.Builder splitPoints = ImmutableSortedSet.orderedBy((Comparator)ByteStringComparator.INSTANCE);
        for (KeyOffset keyOffset : sampledRowKeys) {
            if (keyOffset.getKey().isEmpty()) continue;
            splitPoints.add((Object)keyOffset.getKey());
        }
        return this.shard((SortedSet<ByteString>)splitPoints.build());
    }

    public List<Query> shard(SortedSet<ByteString> splitPoints) {
        Preconditions.checkState((this.builder.getRowsLimit() == 0L ? 1 : 0) != 0, (Object)"Can't shard a query with a row limit");
        List<RowSet> shardedRowSets = RowSetUtil.shard(this.builder.getRows(), splitPoints);
        ArrayList shards = Lists.newArrayListWithCapacity((int)shardedRowSets.size());
        for (RowSet rowSet : shardedRowSets) {
            Query queryShard = new Query(this.tableId);
            queryShard.builder.mergeFrom(this.builder.build());
            queryShard.builder.setRows(rowSet);
            shards.add(queryShard);
        }
        return shards;
    }

    public Range.ByteStringRange getBound() {
        return RowSetUtil.getBound(this.builder.getRows());
    }

    @InternalApi
    public ReadRowsRequest toProto(RequestContext requestContext) {
        String tableName = NameUtil.formatTableName(requestContext.getProjectId(), requestContext.getInstanceId(), this.tableId);
        return this.builder.setTableName(tableName).setAppProfileId(requestContext.getAppProfileId()).build();
    }

    public static Query fromProto(@Nonnull ReadRowsRequest request) {
        Preconditions.checkArgument((request != null ? 1 : 0) != 0, (Object)"ReadRowsRequest must not be null");
        Query query = new Query(NameUtil.extractTableIdFromTableName(request.getTableName()));
        query.builder = request.toBuilder();
        return query;
    }

    private static ByteString wrapKey(String key) {
        if (key == null) {
            return null;
        }
        return ByteString.copyFromUtf8((String)key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equal((Object)this.tableId, (Object)query.tableId) && Objects.equal((Object)this.builder.build(), (Object)query.builder.build());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tableId, this.builder.build()});
    }

    public String toString() {
        ReadRowsRequest request = this.builder.build();
        return MoreObjects.toStringHelper((Object)this).add("tableId", (Object)this.tableId).add("keys", (Object)request.getRows().getRowKeysList()).add("ranges", (Object)request.getRows().getRowRangesList()).add("filter", (Object)request.getFilter()).toString();
    }
}

