/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.data.handlers;

import com.dbeaver.ee.mongodb.data.MongoListValue;
import com.dbeaver.ee.mongodb.data.MongoMapValue;
import com.dbeaver.ee.mongodb.data.handlers.MongoBaseValueHandler;
import com.dbeaver.ee.mongodb.exec.MongoCustomStatement;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import com.mongodb.BasicDBList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MongoListValueHandler
extends MongoBaseValueHandler
implements DBDValueHandlerComposite {
    public static final MongoListValueHandler INSTANCE = new MongoListValueHandler();

    @NotNull
    public Class<List> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return List.class;
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        MongoDataSource dataSource = (MongoDataSource)session.getDataSource();
        if (object == null) {
            return new MongoListValue(dataSource, null);
        }
        if (object instanceof MongoListValue) {
            return copy ? ((MongoListValue)((Object)object)).cloneValue(session.getProgressMonitor()) : object;
        }
        if (object instanceof BasicDBList) {
            return new MongoListValue(dataSource, (BasicDBList)object);
        }
        if (object instanceof String) {
            BasicDBList dbList = new BasicDBList();
            dbList.add(object);
            return new MongoListValue(dataSource, dbList);
        }
        if (object instanceof Collection) {
            BasicDBList dbList = new BasicDBList();
            for (Object item : (Collection)object) {
                dbList.add(item);
            }
            return new MongoListValue(dataSource, dbList);
        }
        if (object instanceof DBDCollection) {
            BasicDBList dbList = new BasicDBList();
            DBDCollection collection = (DBDCollection)object;
            int itemCount = collection.getItemCount();
            DBDValueHandler itemValueHandler = collection.getComponentValueHandler();
            int i = 0;
            while (i < itemCount) {
                Object itemValue = itemValueHandler.getValueFromObject(session, (DBSTypedObject)collection.getComponentType(), collection.getItem(i), false);
                dbList.add(itemValue);
                ++i;
            }
            return new MongoListValue(dataSource, dbList);
        }
        throw new DBCException("Unsupported mongo collection type: " + object.getClass().getName());
    }

    @Override
    protected void bindParameter(MongoSession session, MongoCustomStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
    }

    public Object createNewValueObject(@NotNull DBCSession session, @NotNull DBSTypedObject type) {
        Object attributeValue;
        DBSDataType dataType = null;
        if (type instanceof MongoMapValue.MapElement && type instanceof DBSAttributeBase && (attributeValue = ((MongoMapValue.MapElement)type).getContainer().getAttributeValue((DBSAttributeBase)type)) instanceof MongoListValue) {
            dataType = ((MongoListValue)((Object)attributeValue)).getComponentType();
        }
        return new MongoListValue((MongoDataSource)session.getDataSource(), new BasicDBList(), dataType);
    }
}

