/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.model.DB2Bufferpool;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2GlobalObject;
import org.jkiss.dbeaver.ext.db2.model.DB2StorageGroup;
import org.jkiss.dbeaver.ext.db2.model.DB2TablespaceContainer;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TablespaceContainerCache;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TablespaceDataType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TablespaceType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2Tablespace
extends DB2GlobalObject
implements DBPNamedObject,
DBPRefreshableObject {
    private final DB2TablespaceContainerCache containerCache = new DB2TablespaceContainerCache();
    private String name;
    private String owner;
    private DB2OwnerType ownerType;
    private Timestamp createTime;
    private Integer tbspaceId;
    private DB2TablespaceType tbspaceType;
    private DB2TablespaceDataType dataType;
    private Integer extentSize;
    private Integer prefetchSize;
    private Double overHead;
    private Double transferRate;
    private Double writeOverHead;
    private Double writeTransferRate;
    private Integer pageSize;
    private String dbpgName;
    private Boolean dropRecovery;
    private Integer dataTag;
    private DB2StorageGroup storageGroup;
    private Integer effectivePrefetchSize;
    private String remarks;
    private DB2Bufferpool bufferpool;

    public DB2Tablespace(DB2DataSource db2DataSource, String db2TablespaceName) throws DBException {
        super(db2DataSource, false);
        this.name = db2TablespaceName;
    }

    public DB2Tablespace(DB2DataSource db2DataSource, ResultSet dbResult) throws DBException {
        super(db2DataSource, true);
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TBSPACE");
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.tbspaceId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"TBSPACEID");
        this.tbspaceType = (DB2TablespaceType)CommonUtils.valueOf(DB2TablespaceType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TBSPACETYPE"));
        this.dataType = (DB2TablespaceDataType)CommonUtils.valueOf(DB2TablespaceDataType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATATYPE"));
        this.extentSize = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"EXTENTSIZE");
        this.prefetchSize = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PREFETCHSIZE");
        this.overHead = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"OVERHEAD");
        this.transferRate = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"TRANSFERRATE");
        this.pageSize = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PAGESIZE");
        this.dbpgName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DBPGNAME");
        this.dropRecovery = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"DROP_RECOVERY", (String)DB2YesNo.Y.name());
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        if (db2DataSource.isAtLeastV9_5()) {
            this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        }
        if (db2DataSource.isAtLeastV9_5()) {
            this.writeOverHead = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"WRITEOVERHEAD");
            this.writeTransferRate = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"WRITETRANSFERRATE");
        }
        if (db2DataSource.isAtLeastV10_1()) {
            this.dataTag = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"DATATAG");
            this.effectivePrefetchSize = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"EFFECTIVEPREFETCHSIZE");
            this.writeOverHead = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"WRITEOVERHEAD");
            this.writeTransferRate = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"WRITETRANSFERRATE");
            String storageGroupName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SGNAME");
            if (storageGroupName != null) {
                this.storageGroup = db2DataSource.getStorageGroup((DBRProgressMonitor)new VoidProgressMonitor(), storageGroupName);
            }
        }
        Integer bufferpoolId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"BUFFERPOOLID");
        this.bufferpool = DB2Utils.findBufferpoolById((DBRProgressMonitor)new VoidProgressMonitor(), db2DataSource, bufferpoolId);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.containerCache.clearCache();
        return this;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public Integer getTbspaceId() {
        return this.tbspaceId;
    }

    @Property(viewable=true, order=3)
    public DB2Bufferpool getBufferPool() {
        return this.bufferpool;
    }

    @Property(viewable=true, order=4)
    public DB2StorageGroup getStorageGroup() {
        return this.storageGroup;
    }

    @Property(viewable=true, order=5)
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Property(viewable=true, order=6)
    public DB2TablespaceType getTbspaceType() {
        return this.tbspaceType;
    }

    @Property(viewable=true, order=7)
    public DB2TablespaceDataType getDataType() {
        return this.dataType;
    }

    @Property(viewable=false, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=false, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false, category="Performance")
    public Integer getExtentSize() {
        return this.extentSize;
    }

    @Property(viewable=false, category="Performance")
    public Integer getPrefetchSize() {
        return this.prefetchSize;
    }

    @Property(viewable=false, category="Performance")
    public Double getOverHead() {
        return this.overHead;
    }

    @Property(viewable=false, category="Performance")
    public Double getTransferRate() {
        return this.transferRate;
    }

    @Property(viewable=false, category="Performance")
    public Double getWriteOverHead() {
        return this.writeOverHead;
    }

    @Property(viewable=false, category="Performance")
    public Double getWriteTransferRate() {
        return this.writeTransferRate;
    }

    @Property(viewable=false, category="Performance")
    public Integer getEffectivePrefetchSize() {
        return this.effectivePrefetchSize;
    }

    @Property(viewable=false)
    public String getDbpgName() {
        return this.dbpgName;
    }

    @Property(viewable=false)
    public Boolean getDropRecovery() {
        return this.dropRecovery;
    }

    @Property(viewable=false)
    public Integer getDataTag() {
        return this.dataTag;
    }

    @Override
    @Property(viewable=false, multiline=true)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @Association
    public Collection<DB2TablespaceContainer> getContainers(DBRProgressMonitor monitor) throws DBException {
        return this.containerCache.getAllObjects(monitor, this);
    }

    public DB2TablespaceContainer getContainer(DBRProgressMonitor monitor, long containerId) throws DBException {
        for (DB2TablespaceContainer container : this.containerCache.getAllObjects(monitor, this)) {
            if (container.getContainerId() != containerId) continue;
            return container;
        }
        return null;
    }

    static DB2Tablespace resolveTablespaceReference(DBRProgressMonitor monitor, DB2DataSource dataSource, Object reference) throws DBException {
        if (reference instanceof String) {
            return (DB2Tablespace)dataSource.getTablespaceCache().getObject(monitor, (DBSObject)dataSource, (String)reference);
        }
        return (DB2Tablespace)reference;
    }
}

