/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditorInput;
import org.eclipse.egit.ui.internal.commit.DiffDocument;
import org.eclipse.egit.ui.internal.commit.DiffEditorOutlinePage;
import org.eclipse.egit.ui.internal.commit.DiffRegionFormatter;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.commit.OldNewLogicalLineNumberRulerColumn;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DiffEditorPage
extends TextEditor
implements IFormPage,
IShowInSource,
IShowInTargetList {
    private static final String ADD_ANNOTATION_TYPE = "org.eclipse.egit.ui.commitEditor.diffAdded";
    private static final String REMOVE_ANNOTATION_TYPE = "org.eclipse.egit.ui.commitEditor.diffRemoved";
    private FormEditor formEditor;
    private String title;
    private String pageId;
    private int pageIndex = -1;
    private Control textControl;
    private DiffEditorOutlinePage outlinePage;
    private Annotation[] currentFoldingAnnotations;
    private Annotation[] currentOverviewAnnotations;
    private ThemePreferenceStore overviewStore;
    private DiffRegionFormatter.FileDiffRegion currentFileDiffRange;
    private OldNewLogicalLineNumberRulerColumn lineNumberColumn;
    private boolean plainLineNumbers = false;

    public DiffEditorPage(FormEditor editor, String id, String title) {
        this.pageId = id;
        this.title = title;
        this.setPartName(title);
        this.initialize(editor);
    }

    public DiffEditorPage(FormEditor editor) {
        this(editor, "diffPage", UIText.DiffEditorPage_Title);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IContentOutlinePage.class.equals(adapter)) {
            if (this.outlinePage == null) {
                this.outlinePage = this.createOutlinePage();
                this.outlinePage.setInput(this.getDocumentProvider().getDocument((Object)this.getEditorInput()));
                if (this.currentFileDiffRange != null) {
                    this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)this.currentFileDiffRange));
                }
            }
            return adapter.cast((Object)this.outlinePage);
        }
        return (T)super.getAdapter(adapter);
    }

    private DiffEditorOutlinePage createOutlinePage() {
        DiffEditorOutlinePage page = new DiffEditorOutlinePage();
        page.addSelectionChangedListener(event -> this.doSetSelection(event.getSelection()));
        page.addOpenListener(event -> {
            FormEditor editor = this.getEditor();
            editor.getSite().getPage().activate((IWorkbenchPart)editor);
            editor.setActivePage(this.getId());
            this.doSetSelection(event.getSelection());
        });
        return page;
    }

    public void dispose() {
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
            this.outlinePage = null;
        }
        if (this.overviewStore != null) {
            this.overviewStore.dispose();
            this.overviewStore = null;
        }
        super.dispose();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        DiffViewer viewer = new DiffViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles){

            @Override
            protected void setFont(Font font) {
            }
        };
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        ProjectionSupport projector = new ProjectionSupport((ProjectionViewer)viewer, this.getAnnotationAccess(), this.getSharedColors());
        projector.install();
        viewer.getTextWidget().addCaretListener(event -> {
            if (this.outlinePage != null) {
                DiffRegionFormatter.FileDiffRegion region = this.getFileDiffRange(event.caretOffset);
                if (region != null && !region.equals((Object)this.currentFileDiffRange)) {
                    this.currentFileDiffRange = region;
                    this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)region));
                } else {
                    this.currentFileDiffRange = region;
                }
            }
        });
        return viewer;
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        this.lineNumberColumn = new OldNewLogicalLineNumberRulerColumn(this.plainLineNumbers);
        this.initializeLineNumberRulerColumn(this.lineNumberColumn);
        return this.lineNumberColumn;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.overviewStore = new ThemePreferenceStore();
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{this.overviewStore, EditorsUI.getPreferenceStore()}));
        this.setDocumentProvider((IDocumentProvider)new DiffDocumentProvider());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new DiffViewer.Configuration(this.getPreferenceStore()){

            public IReconciler getReconciler(ISourceViewer sourceViewer) {
                return null;
            }
        });
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (input instanceof DiffEditorInput) {
            DiffRegionFormatter.FileDiffRegion region;
            this.setFolding();
            this.currentFileDiffRange = region = this.getFileDiffRange(0);
            this.setOverviewAnnotations();
        } else if (input instanceof CommitEditorInput) {
            this.formatDiff();
            this.currentFileDiffRange = null;
        }
        if (this.outlinePage != null) {
            this.outlinePage.setInput(this.getDocumentProvider().getDocument((Object)input));
            if (this.currentFileDiffRange != null) {
                this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)this.currentFileDiffRange));
            }
        }
    }

    protected void doSetSelection(ISelection selection) {
        Object selected;
        if (!selection.isEmpty() && selection instanceof StructuredSelection && (selected = ((StructuredSelection)selection).getFirstElement()) instanceof DiffRegionFormatter.FileDiffRegion) {
            DiffRegionFormatter.FileDiffRegion newRange = (DiffRegionFormatter.FileDiffRegion)((Object)selected);
            if (!newRange.equals((Object)this.currentFileDiffRange)) {
                this.currentFileDiffRange = newRange;
                this.selectAndReveal(newRange.getOffset(), 0);
            }
            return;
        }
        super.doSetSelection(selection);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.copy", ITextEditorActionConstants.SELECT_ALL);
        menu.remove("ShiftRight");
        menu.remove("ShiftLeft");
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        IContributionItem showLineNumbers = menu.find("Linenumbers.Toggle");
        boolean isShowingLineNumbers = EditorsUI.getPreferenceStore().getBoolean("lineNumberRuler");
        if (showLineNumbers instanceof ActionContributionItem) {
            ((ActionContributionItem)showLineNumbers).getAction().setChecked(isShowingLineNumbers);
        }
        if (isShowingLineNumbers) {
            final boolean plain = this.lineNumberColumn.isPlain();
            Action togglePlain = new Action(UIText.DiffEditorPage_ToggleLineNumbers, 2){

                public void run() {
                    DiffEditorPage.this.plainLineNumbers = !plain;
                    DiffEditorPage.this.lineNumberColumn.setPlain(!plain);
                }
            };
            togglePlain.setChecked(!plain);
            menu.appendToGroup("rulers", (IAction)togglePlain);
        }
    }

    public void initialize(FormEditor editor) {
        this.formEditor = editor;
    }

    public FormEditor getEditor() {
        return this.formEditor;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public void setActive(boolean active) {
        if (active) {
            this.setFocus();
        }
    }

    public boolean isActive() {
        return ((Object)((Object)this)).equals(this.formEditor.getActivePageInstance());
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public Control getPartControl() {
        return this.textControl;
    }

    public String getId() {
        return this.pageId;
    }

    public int getIndex() {
        return this.pageIndex;
    }

    public void setIndex(int index) {
        this.pageIndex = index;
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object object) {
        if (object instanceof IMarker) {
            IDE.gotoMarker((IEditorPart)this, (IMarker)((IMarker)object));
            return true;
        }
        if (object instanceof ISelection) {
            this.doSetSelection((ISelection)object);
            return true;
        }
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.textControl = children[children.length - 1];
    }

    public ShowInContext getShowInContext() {
        RepositoryCommit commit = (RepositoryCommit)((Object)Adapters.adapt((Object)this.getEditorInput(), RepositoryCommit.class));
        if (commit != null) {
            return new ShowInContext((Object)this.getEditorInput(), (ISelection)new StructuredSelection((Object)commit));
        }
        return null;
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.team.ui.GenericHistoryView", "org.eclipse.egit.ui.RepositoriesView"};
    }

    private void setFolding() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document instanceof DiffDocument) {
            DiffRegionFormatter.FileDiffRegion[] regions = ((DiffDocument)document).getFileRegions();
            if (regions == null || regions.length <= 1) {
                viewer.disableProjection();
                return;
            }
            viewer.enableProjection();
            HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
            DiffRegionFormatter.FileDiffRegion[] fileDiffRegionArray = regions;
            int n = regions.length;
            int n2 = 0;
            while (n2 < n) {
                DiffRegionFormatter.FileDiffRegion region = fileDiffRegionArray[n2];
                newAnnotations.put(new ProjectionAnnotation(), new Position(region.getOffset(), region.getLength()));
                ++n2;
            }
            viewer.getProjectionAnnotationModel().modifyAnnotations(this.currentFoldingAnnotations, newAnnotations, null);
            this.currentFoldingAnnotations = newAnnotations.keySet().toArray(new Annotation[0]);
        } else {
            viewer.disableProjection();
            this.currentFoldingAnnotations = null;
        }
    }

    private void setOverviewAnnotations() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        IDocument document = documentProvider.getDocument((Object)this.getEditorInput());
        if (!(document instanceof DiffDocument)) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null) {
            return;
        }
        DiffRegionFormatter.DiffRegion[] diffs = ((DiffDocument)document).getRegions();
        if (diffs == null || diffs.length == 0) {
            return;
        }
        HashMap<Annotation, Position> newAnnotations = new HashMap<Annotation, Position>();
        DiffRegionFormatter.DiffRegion[] diffRegionArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            DiffRegionFormatter.DiffRegion region = diffRegionArray[n2];
            if (DiffRegionFormatter.DiffRegion.Type.ADD.equals((Object)region.getType())) {
                newAnnotations.put(new Annotation(ADD_ANNOTATION_TYPE, true, null), new Position(region.getOffset(), region.getLength()));
            } else if (DiffRegionFormatter.DiffRegion.Type.REMOVE.equals((Object)region.getType())) {
                newAnnotations.put(new Annotation(REMOVE_ANNOTATION_TYPE, true, null), new Position(region.getOffset(), region.getLength()));
            }
            ++n2;
        }
        if (annotationModel instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.currentOverviewAnnotations, newAnnotations);
        } else {
            if (this.currentOverviewAnnotations != null) {
                diffRegionArray = this.currentOverviewAnnotations;
                n = this.currentOverviewAnnotations.length;
                n2 = 0;
                while (n2 < n) {
                    DiffRegionFormatter.DiffRegion existing = diffRegionArray[n2];
                    annotationModel.removeAnnotation((Annotation)existing);
                    ++n2;
                }
            }
            for (Map.Entry entry : newAnnotations.entrySet()) {
                annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
            }
        }
        this.currentOverviewAnnotations = newAnnotations.keySet().toArray(new Annotation[0]);
    }

    private DiffRegionFormatter.FileDiffRegion getFileDiffRange(int widgetOffset) {
        DiffViewer viewer = (DiffViewer)this.getSourceViewer();
        if (viewer != null) {
            int offset = viewer.widgetOffset2ModelOffset(widgetOffset);
            IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            if (document instanceof DiffDocument) {
                return ((DiffDocument)document).findFileRegion(offset);
            }
        }
        return null;
    }

    protected FileDiff[] getDiffs(RepositoryCommit commit) {
        ArrayList<FileDiff> diffResult = new ArrayList<FileDiff>();
        diffResult.addAll(Arrays.asList(commit.getDiffs()));
        if (commit.getRevCommit().getParentCount() > 2) {
            RevCommit untrackedCommit = commit.getRevCommit().getParent(2);
            diffResult.addAll(Arrays.asList(new RepositoryCommit(commit.getRepository(), untrackedCommit).getDiffs()));
        }
        FileDiff[] result = diffResult.toArray(new FileDiff[0]);
        Arrays.sort(result, FileDiff.PATH_COMPARATOR);
        return result;
    }

    private void formatDiff() {
        final RepositoryCommit commit = (RepositoryCommit)((Object)Adapters.adapt((Object)this.getEditor(), RepositoryCommit.class));
        if (commit == null) {
            return;
        }
        if (!commit.isStash() && commit.getRevCommit().getParentCount() > 1) {
            this.setInput(new DiffEditorInput(commit, null));
            return;
        }
        Job job = new Job(UIText.DiffEditorPage_TaskGeneratingDiff){

            protected IStatus run(IProgressMonitor monitor) {
                FileDiff[] diffs = DiffEditorPage.this.getDiffs(commit);
                final DiffDocument document = new DiffDocument();
                Throwable throwable = null;
                Object var5_6 = null;
                try (DiffRegionFormatter formatter = new DiffRegionFormatter((IDocument)document);){
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)diffs.length);
                    FileDiff[] fileDiffArray = diffs;
                    int n = diffs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileDiff diff = fileDiffArray[n2];
                        if (progress.isCanceled()) break;
                        progress.subTask(diff.getPath());
                        try {
                            formatter.write(diff);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        progress.worked(1);
                        ++n2;
                    }
                    document.connect(formatter);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                new UIJob(UIText.DiffEditorPage_TaskUpdatingViewer){

                    public IStatus runInUIThread(IProgressMonitor uiMonitor) {
                        if (UIUtils.isUsable(DiffEditorPage.this.getPartControl())) {
                            DiffEditorPage.this.setInput(new DiffEditorInput(commit, (IDocument)document));
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static class DiffDocumentProvider
    extends AbstractDocumentProvider {
        private DiffDocumentProvider() {
        }

        public IStatus getStatus(Object element) {
            RepositoryCommit commit;
            if (element instanceof CommitEditorInput && (commit = ((CommitEditorInput)((Object)element)).getCommit()) != null && !commit.isStash() && commit.getRevCommit() != null && commit.getRevCommit().getParentCount() > 1) {
                return Activator.createErrorStatus(UIText.DiffEditorPage_WarningNoDiffForMerge);
            }
            return Status.OK_STATUS;
        }

        protected IDocument createDocument(Object element) throws CoreException {
            IDocument document;
            if (element instanceof DiffEditorInput && (document = ((DiffEditorInput)((Object)element)).getDocument()) != null) {
                return document;
            }
            return new Document();
        }

        protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
            return new AnnotationModel();
        }

        protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        }

        protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
            return null;
        }
    }

    private static class DiffEditorInput
    extends CommitEditorInput {
        private IDocument document;

        public DiffEditorInput(RepositoryCommit commit, IDocument diff) {
            super(commit);
            this.document = diff;
        }

        public IDocument getDocument() {
            return this.document;
        }

        @Override
        public String getName() {
            return UIText.DiffEditorPage_Title;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && obj instanceof DiffEditorInput && Objects.equals(this.document, ((DiffEditorInput)((Object)obj)).document);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ Objects.hashCode(this.document);
        }
    }

    private static class ThemePreferenceStore
    extends PreferenceStore {
        private static final String ADD_ANNOTATION_COLOR_PREFERENCE = "org.eclipse.egit.ui.commitEditor.diffAddedColor";
        private static final String REMOVE_ANNOTATION_COLOR_PREFERENCE = "org.eclipse.egit.ui.commitEditor.diffRemovedColor";
        private final IPropertyChangeListener listener = event -> {
            String property = event.getProperty();
            if ("CHANGE_CURRENT_THEME".equals(property)) {
                this.setColorRegistry();
                this.initColors();
            } else if ("org.eclipse.egit.ui.DiffAddBackgroundColor".equals(property) || "org.eclipse.egit.ui.DiffRemoveBackgroundColor".equals(property)) {
                this.initColors();
            }
        };
        private ColorRegistry currentColors;

        public ThemePreferenceStore() {
            this.setColorRegistry();
            this.initColors();
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.listener);
        }

        private void setColorRegistry() {
            if (this.currentColors != null) {
                this.currentColors.removeListener(this.listener);
            }
            this.currentColors = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
            this.currentColors.addListener(this.listener);
        }

        private void initColors() {
            RGB rgb = this.adjust(this.currentColors.getRGB("org.eclipse.egit.ui.DiffAddBackgroundColor"), 4.0);
            this.setValue(ADD_ANNOTATION_COLOR_PREFERENCE, StringConverter.asString((RGB)rgb));
            rgb = this.adjust(this.currentColors.getRGB("org.eclipse.egit.ui.DiffRemoveBackgroundColor"), 4.0);
            this.setValue(REMOVE_ANNOTATION_COLOR_PREFERENCE, StringConverter.asString((RGB)rgb));
        }

        private RGB adjust(RGB rgb, double saturation) {
            float[] hsb = rgb.getHSB();
            return new RGB(hsb[0], (float)Math.min((double)hsb[1] * saturation, 1.0), (double)hsb[2] < 0.5 ? hsb[2] * 2.0f : hsb[2]);
        }

        public void dispose() {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.listener);
            if (this.currentColors != null) {
                this.currentColors.removeListener(this.listener);
                this.currentColors = null;
            }
        }
    }
}

