/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.application;

import com.dbeaver.ee.application.EnterpriseActionBarAdvisor;
import com.dbeaver.ee.runtime.lm.DBeaverEnterpriseLM;
import com.dbeaver.ee.runtime.ui.lm.LicenseManagerUIUtils;
import com.dbeaver.lm.ui.LicenseUIUtils;
import java.text.SimpleDateFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.application.ApplicationWorkbenchWindowAdvisor;
import org.jkiss.dbeaver.core.application.CommandLineParameterHandler;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;

public class EnterpriseWorkbenchWindowAdvisor
extends ApplicationWorkbenchWindowAdvisor {
    private static final Log log = Log.getLog(EnterpriseWorkbenchWindowAdvisor.class);
    private static final int RC_NOT_LICENSED = 100;

    public EnterpriseWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public void postWindowOpen() {
        UIExecutionQueue.queueExec(() -> {
            LMLicense[] checkResult = new LMLicense[1];
            try {
                Shell shell = this.getWindowConfigurer().getWindow().getShell();
                log.debug((Object)"Check product license");
                this.getWindowConfigurer().getWindow().run(true, true, monitor -> UIUtils.syncExec(() -> {
                    lMLicenseArray[0] = LicenseManagerUIUtils.checkLicense((IProgressMonitor)monitor, (Shell)shell);
                }));
            }
            catch (Throwable e) {
                DBWorkbench.getPlatformUI().showError("License check", "Error checking license information", e);
            }
            LMLicense curLicense = checkResult[0];
            if (curLicense == null) {
                log.debug((Object)"No valid license found");
                System.exit(100);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            log.debug((Object)("License: " + curLicense.getLicenseId() + " (" + curLicense.getLicenseType().getDisplayName() + "; " + dateFormat.format(curLicense.getLicenseIssueTime()) + (curLicense.getLicenseEndTime() == null ? "" : " - " + dateFormat.format(curLicense.getLicenseEndTime())) + ")"));
        });
        super.postWindowOpen();
    }

    protected boolean isRunWorkbenchInitializers() {
        if (!DBeaverEnterpriseLM.hasLicense((String)LicenseUIUtils.getClientId())) {
            return false;
        }
        return super.isRunWorkbenchInitializers();
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new EnterpriseActionBarAdvisor(configurer);
    }

    public static class LicenseParameterHandler
    implements CommandLineParameterHandler {
        public void handleParameter(String name, String value) {
            LMLicenseManager.setLicenseCustomPath((String)value);
        }
    }
}

