/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.application;

import com.dbeaver.ee.application.EnterpriseVersionUpdateDialog;
import com.dbeaver.ee.application.EnterpriseWorkbenchAdvisor;
import com.dbeaver.ee.runtime.core.EnterpriseProjectSecureStorage;
import com.dbeaver.ee.runtime.core.EnterpriseSecureStorage;
import com.dbeaver.ee.runtime.lm.DBeaverEnterpriseLM;
import java.io.File;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.application.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.core.application.DBeaverApplication;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMValidateException;

public class DBeaverEnterpriseApplication
extends DBeaverApplication {
    private static final Log log = Log.getLog(DBeaverEnterpriseApplication.class);
    private DBASecureStorage eeSecureStorage;

    protected void initializeApplication() {
        super.initializeApplication();
        String licenseFileName = ".dbeaver-ee-license.dat";
        File userLicenseFile = new File(System.getProperty("user.home"), licenseFileName);
        File workspaceLicenseFile = new File(GeneralUtils.getMetadataFolder(), licenseFileName);
        LMLicenseManager.addLicenseSearchPath((File)userLicenseFile);
        LMLicenseManager.addLicenseSearchPath((File)workspaceLicenseFile);
    }

    @NotNull
    protected ApplicationWorkbenchAdvisor createWorkbenchAdvisor() {
        return new EnterpriseWorkbenchAdvisor();
    }

    @NotNull
    public DBASecureStorage getSecureStorage() {
        if (this.eeSecureStorage == null) {
            this.eeSecureStorage = new EnterpriseSecureStorage();
        }
        return this.eeSecureStorage;
    }

    @NotNull
    public DBASecureStorage getProjectSecureStorage(DBPProject project) {
        return new EnterpriseProjectSecureStorage(project);
    }

    public String getInfoDetails() {
        LMLicense license;
        block3: {
            try {
                license = DBeaverEnterpriseLM.getValidProductLicense();
                if (license != null) break block3;
                return "Not licensed! ";
            }
            catch (LMValidateException e) {
                log.error((Object)"Error getting license information", (Throwable)e);
                return e.getMessage();
            }
        }
        return "Licensed to " + license.getOwnerFull() + "\n" + "License ID: " + license.getLicenseId();
    }

    public void notifyVersionUpgrade(VersionDescriptor currentVersion, VersionDescriptor newVersion, boolean showSkip) {
        EnterpriseVersionUpdateDialog dialog = new EnterpriseVersionUpdateDialog(UIUtils.getActiveWorkbenchShell(), currentVersion, newVersion, showSkip);
        dialog.open();
    }
}

