/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewType;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardEditDialog;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class DashboardItemConfigDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.DashboardItemConfigDialog";
    private static final boolean SHOW_QUERIES_BUTTON = false;
    private final DashboardItemViewConfiguration dashboardConfig;
    private DashboardViewConfiguration viewConfiguration;
    private DashboardContainer dashboardContainer;

    public DashboardItemConfigDialog(Shell shell, DashboardContainer dashboardContainer, DashboardViewConfiguration viewConfiguration) {
        super(shell, "Dashboard [" + dashboardContainer.getDashboardTitle() + "]", null);
        this.viewConfiguration = viewConfiguration;
        this.dashboardContainer = dashboardContainer;
        this.dashboardConfig = new DashboardItemViewConfiguration(viewConfiguration.getDashboardConfig(dashboardContainer.getDashboardId()));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Group infoGroup = UIUtils.createControlGroup((Composite)composite, (String)"Dashboard info", (int)4, (int)768, (int)0);
        UIUtils.createLabelText((Composite)infoGroup, (String)"Name", (String)this.dashboardConfig.getDashboardDescriptor().getName(), (int)2056).setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        UIUtils.createControlLabel((Composite)infoGroup, (String)"Description").setLayoutData((Object)new GridData(2));
        Text descriptionText = new Text((Composite)infoGroup, 2626);
        descriptionText.setText(CommonUtils.notEmpty((String)this.dashboardConfig.getDescription()));
        descriptionText.addModifyListener(e -> this.dashboardConfig.setDescription(descriptionText.getText()));
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        gd.heightHint = 50;
        descriptionText.setLayoutData((Object)gd);
        Group updateGroup = UIUtils.createControlGroup((Composite)composite, (String)"Dashboard update", (int)2, (int)768, (int)0);
        Text updatePeriodText = UIUtils.createLabelText((Composite)updateGroup, (String)"Update period (ms)", (String)String.valueOf(this.dashboardConfig.getUpdatePeriod()), (int)2048, (Object)new GridData(768));
        updatePeriodText.addModifyListener(e -> this.dashboardConfig.setUpdatePeriod(CommonUtils.toLong((Object)updatePeriodText.getText(), (long)this.dashboardConfig.getUpdatePeriod())));
        Text maxItemsText = UIUtils.createLabelText((Composite)updateGroup, (String)"Maximum items", (String)String.valueOf(this.dashboardConfig.getMaxItems()), (int)2048, (Object)new GridData(768));
        maxItemsText.addModifyListener(e -> this.dashboardConfig.setMaxItems(CommonUtils.toInt((Object)maxItemsText.getText(), (int)this.dashboardConfig.getMaxItems())));
        Group viewGroup = UIUtils.createControlGroup((Composite)composite, (String)"Dashboard view", (int)2, (int)768, (int)0);
        final Combo typeCombo = UIUtils.createLabelCombo((Composite)viewGroup, (String)"View", (String)"Dashboard view", (int)2056);
        typeCombo.setLayoutData((Object)new GridData(768));
        final List<DashboardViewType> viewTypes = DashboardRegistry.getInstance().getSupportedViewTypes(this.dashboardConfig.getDashboardDescriptor().getDataType());
        for (DashboardViewType viewType : viewTypes) {
            typeCombo.add(viewType.getTitle());
        }
        typeCombo.setText(this.dashboardConfig.getViewType().getTitle());
        typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardItemConfigDialog.this.dashboardConfig.setViewType((DashboardViewType)viewTypes.get(typeCombo.getSelectionIndex()));
            }
        });
        UIUtils.createCheckbox((Composite)viewGroup, (String)"Show legend", (String)"Show dashboard chart legend", (boolean)this.dashboardConfig.isLegendVisible(), (int)2).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardItemConfigDialog.this.dashboardConfig.setLegendVisible(((Button)e.widget).getSelection());
            }
        });
        UIUtils.createCheckbox((Composite)viewGroup, (String)"Show grid", (String)"Show dashboard grid", (boolean)this.dashboardConfig.isGridVisible(), (int)2).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardItemConfigDialog.this.dashboardConfig.setGridVisible(((Button)e.widget).getSelection());
            }
        });
        UIUtils.createCheckbox((Composite)viewGroup, (String)"Show domain axis", (String)"Show domain (horizontal) axis", (boolean)this.dashboardConfig.isDomainTicksVisible(), (int)2).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardItemConfigDialog.this.dashboardConfig.setDomainTicksVisible(((Button)e.widget).getSelection());
            }
        });
        UIUtils.createCheckbox((Composite)viewGroup, (String)"Show range axis", (String)"Show range (vertical) axis", (boolean)this.dashboardConfig.isDomainTicksVisible(), (int)2).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardItemConfigDialog.this.dashboardConfig.setRangeTicksVisible(((Button)e.widget).getSelection());
            }
        });
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Configuration", false).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardEditDialog editDialog = new DashboardEditDialog(DashboardItemConfigDialog.this.getShell(), DashboardItemConfigDialog.this.dashboardConfig.getDashboardDescriptor());
                editDialog.open();
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    protected void okPressed() {
        super.okPressed();
        this.viewConfiguration.updateDashboardConfig(this.dashboardConfig);
        this.viewConfiguration.saveSettings();
    }
}

