/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.model;

import com.dbeaver.ee.influxdb.InfluxConstants;
import com.dbeaver.ee.model.NoSQLDialect;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class InfluxSQLDialect
extends NoSQLDialect {
    public static final InfluxSQLDialect INSTANCE = new InfluxSQLDialect();

    public InfluxSQLDialect() {
        this.addKeywords(Arrays.asList(InfluxConstants.IQL_KEYWORDS), DBPKeywordType.KEYWORD);
        this.addFunctions(Arrays.asList(InfluxConstants.IQL_FUNCTIONS));
    }

    @NotNull
    public String getDialectName() {
        return "InfluxQL";
    }

    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return DBPIdentifierCase.MIXED;
    }

    public boolean validIdentifierStart(char c) {
        return super.validIdentifierStart(c) || c == '_';
    }

    public boolean supportsAliasInSelect() {
        return false;
    }

    public boolean supportsAliasInUpdate() {
        return false;
    }

    public boolean supportsSubqueries() {
        return false;
    }

    @NotNull
    public String escapeScriptValue(DBSAttributeBase attribute, @NotNull Object value, @NotNull String strValue) {
        if (value instanceof String) {
            return String.valueOf('\'') + this.escapeString(strValue) + '\'';
        }
        return strValue;
    }
}

