/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import com.dbeaver.ee.scmp.impl.liquibase.LBResultChangeSet;
import com.dbeaver.ee.scmp.model.CMPResultChangeItem;
import com.dbeaver.ee.scmp.model.CMPResultChangeType;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeMetaData;
import liquibase.change.ChangeParameterMetaData;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.DropDefaultValueChange;
import liquibase.change.core.DropForeignKeyConstraintChange;
import liquibase.change.core.DropNotNullConstraintChange;
import liquibase.database.Database;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class LBResultChangeItem
implements CMPResultChangeItem {
    private static final Log log = Log.getLog(LBResultChangeItem.class);
    private final LBResultChangeSet changeSet;
    private final Change change;
    private final ChangeMetaData changeMetaData;
    private final DBSObjectType objectType;
    private boolean enabled = true;

    public LBResultChangeItem(LBResultChangeSet changeSet, Change change) {
        this.changeSet = changeSet;
        this.change = change;
        this.changeMetaData = ChangeFactory.getInstance().getChangeMetaData(change);
        this.objectType = LBResultChangeItem.getChangeObjectType(change);
    }

    public Change getChange() {
        return this.change;
    }

    public ChangeMetaData getChangeMetaData() {
        return this.changeMetaData;
    }

    @Override
    public String getCatalogName() {
        if (this.ifForeignKeyChange()) {
            return this.getParameterValue("baseTableCatalogName");
        }
        return this.getParameterValue("catalogName");
    }

    @Override
    public String getSchemaName() {
        if (this.ifForeignKeyChange()) {
            return this.getParameterValue("baseTableSchemaName");
        }
        return this.getParameterValue("schemaName");
    }

    @Override
    public String getObjectName() {
        if (this.ifForeignKeyChange()) {
            return this.getParameterValue("baseTableName");
        }
        if (this.hasParameter("tableName")) {
            return this.getParameterValue("tableName");
        }
        if (this.hasParameter("viewName")) {
            return this.getParameterValue("viewName");
        }
        if (this.hasParameter("sequenceName")) {
            return this.getParameterValue("sequenceName");
        }
        return null;
    }

    @Override
    public String getInnerName() {
        if (this.objectType == RelationalObjectType.TYPE_CONSTRAINT) {
            return this.getParameterValue("constraintName");
        }
        if (this.objectType == RelationalObjectType.TYPE_TABLE_COLUMN) {
            Object columnsValue;
            if (this.hasParameter("columnName")) {
                return this.getParameterValue("columnName");
            }
            ChangeParameterMetaData columnsParam = (ChangeParameterMetaData)this.changeMetaData.getParameters().get("columns");
            if (columnsParam != null && (columnsValue = columnsParam.getCurrentValue(this.change)) instanceof List) {
                List columnsList = (List)columnsValue;
                CharSequence[] columnNames = new String[columnsList.size()];
                int i = 0;
                while (i < columnsList.size()) {
                    columnNames[i] = ((AddColumnConfig)columnsList.get(i)).getName();
                    ++i;
                }
                return String.join((CharSequence)",", columnNames);
            }
        } else if (this.objectType == RelationalObjectType.TYPE_INDEX) {
            return this.getParameterValue("indexName");
        }
        return null;
    }

    @Override
    public DBSObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public String getChangeDetails() {
        Database targetDatabase = this.changeSet.getTargetDatabase();
        if (targetDatabase != null) {
            StringWriter buf = new StringWriter();
            try {
                targetDatabase.saveStatements(this.change, null, (Writer)buf);
                return buf.toString();
            }
            catch (Exception e) {
                log.debug((Object)("Error generating change script: " + e.getMessage()));
            }
        }
        return "-- " + this.change.getDescription();
    }

    @Override
    public String getChangeAction() {
        return this.changeMetaData.getDescription();
    }

    @Override
    public CMPResultChangeType getChangeType() {
        String className = this.change.getClass().getSimpleName();
        if (className.startsWith("Create") || className.startsWith("Add")) {
            return CMPResultChangeType.CREATE;
        }
        if (className.startsWith("Drop")) {
            if (this.change instanceof DropDefaultValueChange || this.change instanceof DropNotNullConstraintChange || this.change.getClass().getSimpleName().equals("DropCheckChange")) {
                return CMPResultChangeType.ALTER;
            }
            return CMPResultChangeType.DROP;
        }
        if (className.startsWith("Rename")) {
            return CMPResultChangeType.RENAME;
        }
        return CMPResultChangeType.ALTER;
    }

    @Override
    public DBSObject getObject(DBRProgressMonitor monitor) throws DBException {
        String innerName;
        DBSObject object;
        DBSObjectContainer sourceContainer;
        boolean fromSource;
        DBPDataSourceContainer dsContainer;
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaName();
        switch (this.getChangeType()) {
            case CREATE: 
            case ALTER: {
                dsContainer = this.changeSet.getOptions().getSourceInput().getDataSourceContainer();
                this.changeSet.getSourceDatabase();
                fromSource = true;
                break;
            }
            default: {
                dsContainer = this.changeSet.getOptions().getTargetInput().getDataSourceContainer();
                this.changeSet.getTargetDatabase();
                fromSource = false;
            }
        }
        DBPDataSource dataSource = dsContainer.getDataSource();
        if (!(dataSource instanceof DBSObjectContainer)) {
            return null;
        }
        if (CommonUtils.isEmpty((String)catalogName)) {
            catalogName = null;
        }
        if (CommonUtils.isEmpty((String)schemaName)) {
            schemaName = null;
        }
        if (schemaName != null && fromSource && (sourceContainer = this.changeSet.getOptions().getSourceContainer(schemaName)) != null) {
            schemaName = sourceContainer.getName();
        }
        if ((object = DBUtils.getObjectByPath((DBRProgressMonitor)monitor, (DBSObjectContainer)((DBSObjectContainer)dataSource), (String)catalogName, (String)schemaName, (String)this.getObjectName())) instanceof DBSEntity && !CommonUtils.isEmpty((String)(innerName = this.getInnerName()))) {
            return ((DBSEntity)object).getAttribute(monitor, innerName);
        }
        return object;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private boolean ifForeignKeyChange() {
        return this.change instanceof AddForeignKeyConstraintChange || this.change instanceof DropForeignKeyConstraintChange;
    }

    private <T> T getChangeProperty(String propertyName) {
        try {
            Object propValue = BeanUtils.readObjectProperty((Object)this.change, (String)propertyName);
            return (T)propValue;
        }
        catch (Exception e) {
            log.debug((Object)("Error reading LB change property '" + propertyName + "'"), (Throwable)e);
            return null;
        }
    }

    private boolean hasParameter(String paramName) {
        return this.changeMetaData.getParameters().get(paramName) != null;
    }

    private String getParameterValue(String paramName) {
        ChangeParameterMetaData param = (ChangeParameterMetaData)this.changeMetaData.getParameters().get(paramName);
        if (param != null) {
            return CommonUtils.toString((Object)param.getCurrentValue(this.change));
        }
        return null;
    }

    public String getFullyQualifiedName(DBPEvaluationContext context) {
        String schemaName;
        String catalogName;
        Database database = this.changeSet.getTargetDatabase();
        ArrayList<String> names = new ArrayList<String>();
        if (database.supportsCatalogs() && (catalogName = this.getCatalogName()) != null) {
            names.add(catalogName);
        }
        if (database.supportsSchemas() && (schemaName = this.getSchemaName()) != null) {
            names.add(schemaName);
        }
        names.add(this.getObjectName());
        return DBUtils.getSimpleQualifiedName((Object[])names.toArray());
    }

    public static DBSObjectType getChangeObjectType(Change change) {
        String className = change.getClass().getName();
        if (className.contains("TableChange") || className.contains("TableRemarksChange")) {
            return RelationalObjectType.TYPE_TABLE;
        }
        if (className.contains("ViewChange")) {
            return RelationalObjectType.TYPE_VIEW;
        }
        if (className.contains("ColumnChange") || className.contains("ColumnRemarksChange") || className.contains("DefaultValueChange") || className.contains("ModifyDataTypeChange")) {
            return RelationalObjectType.TYPE_TABLE_COLUMN;
        }
        if (className.contains("ConstraintChange") || className.contains("PrimaryKeyChange")) {
            return RelationalObjectType.TYPE_CONSTRAINT;
        }
        if (className.contains("IndexChange")) {
            return RelationalObjectType.TYPE_INDEX;
        }
        if (className.contains("ProcedureChange")) {
            return RelationalObjectType.TYPE_PROCEDURE;
        }
        if (className.contains("SequenceChange")) {
            return RelationalObjectType.TYPE_SEQUENCE;
        }
        if (className.contains("TriggerChange")) {
            return RelationalObjectType.TYPE_TRIGGER;
        }
        return RelationalObjectType.TYPE_UNKNOWN;
    }

    public String toString() {
        return "CMPResultChangeItem [catalogName=" + this.getCatalogName() + ", schemaName=" + this.getSchemaName() + ", objectName=" + this.getObjectName() + ", innerName=" + this.getInnerName() + ", objectType=" + this.getObjectType() + ", changeType=" + (Object)((Object)this.getChangeType()) + ", changeDetails=" + this.getChangeDetails() + "]";
    }
}

