/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;
import org.jkiss.dbeaver.model.net.ssh.SSHAgentIdentity;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementationAbstract;

public class DBeaverAuthAgent
extends AbstractAuthMethod {
    private final SSHAgentIdentity identity;
    private final String algorithm;
    private final SSHImplementationAbstract impl;

    public DBeaverAuthAgent(SSHImplementationAbstract impl, SSHAgentIdentity identity) throws Buffer.BufferException {
        super("publickey");
        this.identity = identity;
        this.algorithm = new Buffer.PlainBuffer(identity.getBlob()).readString();
        this.impl = impl;
    }

    public void handle(Message cmd, SSHPacket buf) throws UserAuthException, TransportException {
        if (cmd == Message.USERAUTH_60) {
            this.sendSignedReq();
        } else {
            super.handle(cmd, buf);
        }
    }

    protected SSHPacket putPubKey(SSHPacket reqBuf) throws UserAuthException {
        ((SSHPacket)((SSHPacket)reqBuf.putString(this.algorithm)).putBytes(this.identity.getBlob())).getCompactData();
        return reqBuf;
    }

    private SSHPacket putSig(SSHPacket reqBuf) throws UserAuthException {
        byte[] dataToSign = ((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(this.params.getTransport().getSessionID())).putBuffer((Buffer)reqBuf)).getCompactData();
        reqBuf.putBytes(this.impl.agentSign(this.identity.getBlob(), dataToSign));
        return reqBuf;
    }

    private void sendSignedReq() throws UserAuthException, TransportException {
        this.params.getTransport().write(this.putSig(this.buildReq(true)));
    }

    private SSHPacket buildReq(boolean signed) throws UserAuthException {
        return this.putPubKey((SSHPacket)super.buildReq().putBoolean(signed));
    }

    protected SSHPacket buildReq() throws UserAuthException {
        return this.buildReq(false);
    }
}

