/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.ArrayList;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.CachedExpr;
import oracle.xml.xpath.XPathConstantExpr;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathFunctionCall;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprConstants;
import oracle.xml.xpath.XSLNodeSetExpr;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;

public abstract class XSLExprBase
implements XSLExprConstants {
    XSLExprBase leftExpr;
    XSLExprBase rightExpr;
    int exprType;
    XPathPredicate predicates;
    int operator;
    float priority;
    int version;
    int flag = -1;
    boolean bkwdCompFlag;
    boolean fwdCompFlag;
    static final int CTX_POSITION = 1;
    static final int CTX_SIZE = 2;
    static final int CTX_NODE = 4;

    void clone(XSLExprBase xSLExprBase, boolean bl) {
        xSLExprBase.leftExpr = this.leftExpr;
        xSLExprBase.rightExpr = this.rightExpr;
        xSLExprBase.exprType = this.exprType;
        xSLExprBase.predicates = bl ? this.predicates : null;
        xSLExprBase.operator = this.operator;
        xSLExprBase.priority = this.priority;
        xSLExprBase.version = this.version;
        xSLExprBase.bkwdCompFlag = this.bkwdCompFlag;
        xSLExprBase.fwdCompFlag = this.fwdCompFlag;
    }

    XPathPredicate getPredicate() {
        return this.predicates;
    }

    void setPredicate(XPathPredicate xPathPredicate) {
        this.predicates = xPathPredicate;
    }

    public static XSLExprBase createExpression(String string, NSResolver nSResolver, XSLStylesheet xSLStylesheet) throws XSLException, XQException {
        Object object;
        if (string == "") {
            throw new XPathException(1025);
        }
        XSLParseString xSLParseString = new XSLParseString(string, nSResolver, xSLStylesheet);
        if (nSResolver instanceof XSLNode) {
            object = (XSLNode)nSResolver;
            xSLParseString.setXSLNode((XSLNode)object);
            xSLParseString.setCompatibilityFlags(((XSLNode)object).getXSLTVersion(), ((XSLNode)object).isBackwardCompatibilityMode(), ((XSLNode)object).isForwardCompatibilityMode());
        } else {
            xSLParseString.setCompatibilityFlags(10, false, false);
        }
        object = XSLExpr.parse(xSLParseString);
        ((XSLExprBase)object).setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
        if (xSLParseString.nextToken() != -1) {
            throw new XPathException(1026, new String(xSLParseString.getExprString()));
        }
        if (xSLParseString.isCachingExpr() && ((XSLExprBase)object).canCacheExpr()) {
            object = ((XSLExprBase)object).createCachedExpr();
        }
        return object;
    }

    public static XSLExprBase createExpression(String string, NSResolver nSResolver, int n) throws XSLException, XQException {
        if (string == "") {
            throw new XPathException(1025);
        }
        XSLParseString xSLParseString = new XSLParseString(string, nSResolver, null);
        if (nSResolver instanceof XSLNode) {
            xSLParseString.setXSLNode((XSLNode)nSResolver);
        }
        xSLParseString.setCompatibilityFlags(n, false, false);
        XSLExprBase xSLExprBase = XSLExpr.parse(xSLParseString);
        xSLExprBase.setCompatibilityFlags(n, false, false);
        if (xSLParseString.nextToken() != -1) {
            throw new XPathException(1026, new String(xSLParseString.getExprString()));
        }
        if (xSLParseString.isCachingExpr() && xSLExprBase.canCacheExpr()) {
            xSLExprBase = xSLExprBase.createCachedExpr();
        }
        return xSLExprBase;
    }

    public static XSLExprBase createPattern(String string, NSResolver nSResolver, boolean bl, XSLStylesheet xSLStylesheet) throws XSLException, XQException {
        Object object;
        if (string == "") {
            throw new XPathException(1025);
        }
        XSLParseString xSLParseString = new XSLParseString(string, nSResolver, xSLStylesheet);
        if (nSResolver instanceof XSLNode) {
            xSLParseString.setXSLNode((XSLNode)nSResolver);
        }
        if (nSResolver instanceof XSLNode) {
            object = (XSLNode)nSResolver;
            xSLParseString.setCompatibilityFlags(((XSLNode)object).getXSLTVersion(), ((XSLNode)object).isBackwardCompatibilityMode(), ((XSLNode)object).isForwardCompatibilityMode());
        } else {
            xSLParseString.setCompatibilityFlags(10, false, false);
        }
        xSLParseString.setVarRestricted(bl);
        xSLParseString.setPattern(true);
        object = XSLNodeSetExpr.parse(xSLParseString);
        ((XSLExprBase)object).setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
        if (xSLParseString.nextToken() != -1) {
            throw new XPathException(1026, new String(xSLParseString.getExprString()));
        }
        return object;
    }

    public void setEvaluationHints(String string, Object object) {
    }

    public boolean isStreamable() {
        return false;
    }

    public ArrayList getStepList() {
        return null;
    }

    public boolean isSimpleExpr() {
        return false;
    }

    void setExprType(int n) {
        this.exprType = n;
    }

    public int getExprType() {
        return this.exprType;
    }

    boolean isExprType(int n) {
        int n2 = this.exprType & n & 0xFFFFFE;
        return n2 == (this.exprType & 0xFFFFFE);
    }

    boolean mayBeExprType(int n) {
        return (this.exprType & n & 0xFFFFFE) > 0;
    }

    int checkPosLastFN() {
        if (this.flag < 0) {
            this.flag = this.leftExpr.checkPosLastFN() | this.rightExpr.checkPosLastFN();
        }
        return this.flag;
    }

    XSLExprBase createCachedExpr() throws XQException {
        return new CachedExpr(this, this.getNormalizedExpr());
    }

    abstract void cacheSubExpr() throws XQException;

    abstract boolean canCacheExpr();

    public abstract String getNormalizedExpr() throws XQException;

    public abstract void evaluate(XPathRuntimeContext var1) throws XSLException, XQException;

    public void streamingEvaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        this.evaluate(xPathRuntimeContext);
    }

    public OXMLSequence getValue(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        this.evaluate(xPathRuntimeContext);
        XPathSequence xPathSequence = new XPathSequence(xPathRuntimeContext);
        XPathSequence.concatSequence(xPathSequence, xPathRuntimeContext.popExprValue());
        return xPathSequence;
    }

    public boolean testBooleanExpr(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        this.evaluate(xPathRuntimeContext);
        return XPathSequence.getBooleanValue(xPathRuntimeContext.popExprValue());
    }

    public String getStringValue(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        this.evaluate(xPathRuntimeContext);
        return XPathSequence.getStringValue(xPathRuntimeContext.popExprValue());
    }

    public double getNumberValue(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        this.evaluate(xPathRuntimeContext);
        return XPathSequence.getNumberValue(xPathRuntimeContext.popExprValue());
    }

    XMLDocumentFragment getResultTree(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        this.evaluate(xPathRuntimeContext);
        return XPathSequence.getResultTreeValue(xPathRuntimeContext.popExprValue());
    }

    Object getExtensionValue(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        this.evaluate(xPathRuntimeContext);
        return XPathSequence.getExtensionValue(xPathRuntimeContext.popExprValue());
    }

    boolean isAttrExpr() {
        if (this.operator != 210) {
            return false;
        }
        return this.leftExpr instanceof XPathStep && this.leftExpr instanceof XPathConstantExpr && ((XPathStep)this.leftExpr).getAnchorType() == 2;
    }

    final int getPositionTest() {
        if (this.operator >= 210 && this.operator <= 221) {
            XPathConstantExpr xPathConstantExpr;
            XPathFunctionCall xPathFunctionCall;
            if (this.operator == 211 || this.operator == 217) {
                return 0;
            }
            if (this.leftExpr instanceof XPathConstantExpr && this.rightExpr instanceof XPathFunctionCall && (this.operator == 210 || this.operator == 216 || this.operator == 214 || this.operator == 220 || this.operator == 215 || this.operator == 221)) {
                xPathFunctionCall = (XPathFunctionCall)this.rightExpr;
                xPathConstantExpr = (XPathConstantExpr)this.leftExpr;
                if (xPathFunctionCall.funcId == -24) {
                    return xPathConstantExpr.getPositionValue();
                }
            }
            if (this.leftExpr instanceof XPathFunctionCall && this.rightExpr instanceof XPathConstantExpr && (this.operator == 210 || this.operator == 216 || this.operator == 212 || this.operator == 218 || this.operator == 213 || this.operator == 219)) {
                xPathFunctionCall = (XPathFunctionCall)this.leftExpr;
                xPathConstantExpr = (XPathConstantExpr)this.rightExpr;
                if (xPathFunctionCall.funcId == -24) {
                    return xPathConstantExpr.getPositionValue();
                }
            }
        } else if (this.operator == 107) {
            int n = this.leftExpr.getPositionTest();
            int n2 = this.rightExpr.getPositionTest();
            if (n == 0 || n2 <= n) {
                return n2;
            }
            if (n2 == 0 || n <= n2) {
                return n;
            }
        } else if (this instanceof XPathConstantExpr) {
            return ((XPathConstantExpr)this).getPositionValue();
        }
        return 0;
    }

    protected void filterPredicates(XPathRuntimeContext xPathRuntimeContext) throws XPathException, XSLException, XQException {
        OXMLSequence oXMLSequence = xPathRuntimeContext.peekExprValue();
        if (!oXMLSequence.isOfType(OXMLSequenceType.NODE_ZERO_OR_MORE)) {
            throw new XPathException(1022);
        }
        this.predicates.filter(oXMLSequence, xPathRuntimeContext);
    }

    public XSLExprBase matchPattern(XMLNode xMLNode, float f, XSLTContext xSLTContext) throws XSLException, XQException {
        return null;
    }

    boolean matchNodeList(XMLNode xMLNode, OXMLSequence oXMLSequence, XSLTContext xSLTContext) throws XSLException, XQException {
        return false;
    }

    public int matchPattern(XSLExprBase xSLExprBase, float f) throws XSLException {
        return 0;
    }

    public float getPriority() throws XSLException {
        return this.priority;
    }

    public void setPriority(float f) throws XSLException {
        this.priority = f;
    }

    public int getAnchorType() throws XSLException {
        return -1;
    }

    public void getAnchorName(String[] stringArray) throws XSLException {
    }

    void setCompatibilityFlags(int n, boolean bl, boolean bl2) {
        this.version = n;
        this.bkwdCompFlag = bl;
        this.fwdCompFlag = bl2;
    }

    int getXSLTVersion() {
        return this.version;
    }

    boolean isBackwardCompatibilityMode() {
        return this.bkwdCompFlag;
    }

    boolean isForwardCompatibilityMode() {
        return this.fwdCompFlag;
    }

    void setFlag(int n) {
        this.flag |= n;
    }

    boolean hasFlag(int n) {
        return (n & this.flag) > 0;
    }
}

