/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.model;

import com.dbeaver.ee.vqb.VQBUtils;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDElement;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ERDJoin
extends ERDAssociation {
    public ERDJoin(ERDEntity sourceEntity, ERDEntity targetEntity, boolean reflect) {
        super((ERDElement)sourceEntity, (ERDElement)targetEntity, reflect);
    }

    public Expression makeExpressionFromConditions() {
        List source = this.getSourceAttributes();
        List target = this.getTargetAttributes();
        if (source.isEmpty()) {
            return null;
        }
        Expression expr = this.makeEquals((ERDEntityAttribute)source.get(0), (ERDEntityAttribute)target.get(0));
        if (source.size() == 1) {
            return expr;
        }
        return this.makeAndExpression(source, target, 1, expr);
    }

    public ERDEntity getSourceEntity() {
        return (ERDEntity)super.getSourceEntity();
    }

    public ERDEntity getTargetEntity() {
        return (ERDEntity)super.getTargetEntity();
    }

    private Expression makeAndExpression(List<ERDEntityAttribute> source, List<ERDEntityAttribute> target, int index, Expression expr) {
        if (index < source.size() - 1) {
            return new AndExpression(this.makeAndExpression(source, target, index + 1, expr), expr);
        }
        return new AndExpression(expr, this.makeEquals(source.get(index), target.get(index)));
    }

    private Expression makeEquals(ERDEntityAttribute src, ERDEntityAttribute target) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression(this.makeColumn(this.getSourceEntity(), src));
        equalsTo.setRightExpression(this.makeColumn(this.getTargetEntity(), target));
        return equalsTo;
    }

    private Expression makeColumn(ERDEntity srcEntity, ERDEntityAttribute src) {
        return new Column(VQBUtils.getTableFromEntity(srcEntity), DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)src.getObject())));
    }

    public void makeConditionsFromReferrer(DBSEntityReferrer association, ERDEntity sourceEntity, ERDEntity targetEntity) {
        this.resolveAttributes(association, sourceEntity, targetEntity);
    }

    public Join createStatementJoin() {
        Join join = new Join();
        join.setInner(true);
        join.setRightItem((FromItem)this.getTargetEntity().getUserData());
        join.setOnExpression(this.makeExpressionFromConditions());
        this.setUserData(join);
        return join;
    }

    public void updateStatementJoin(Join join) {
        join.setOnExpression(this.makeExpressionFromConditions());
        this.setUserData(join);
    }
}

