/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ExperimentalApi;
import io.grpc.ProxyDetector;
import io.grpc.Status;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
@ThreadSafe
public abstract class NameResolver {
    public abstract String getServiceAuthority();

    public abstract void start(Listener var1);

    public abstract void shutdown();

    public void refresh() {
    }

    public static abstract class Helper {
        public abstract int getDefaultPort();

        public abstract ProxyDetector getProxyDetector();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4972")
    public static @interface ResolutionResultAttr {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    @ThreadSafe
    public static interface Listener {
        public void onAddresses(List<EquivalentAddressGroup> var1, Attributes var2);

        public void onError(Status var1);
    }

    public static abstract class Factory {
        @Deprecated
        public static final Attributes.Key<Integer> PARAMS_DEFAULT_PORT = Attributes.Key.create("params-default-port");
        @Deprecated
        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/5113")
        public static final Attributes.Key<ProxyDetector> PARAMS_PROXY_DETECTOR = Attributes.Key.create("params-proxy-detector");

        @Nullable
        @Deprecated
        public NameResolver newNameResolver(URI targetUri, Attributes params) {
            throw new UnsupportedOperationException("This method is going to be deleted");
        }

        @Nullable
        public NameResolver newNameResolver(URI targetUri, Helper helper) {
            return this.newNameResolver(targetUri, Attributes.newBuilder().set(PARAMS_DEFAULT_PORT, helper.getDefaultPort()).set(PARAMS_PROXY_DETECTOR, helper.getProxyDetector()).build());
        }

        public abstract String getDefaultScheme();
    }
}

