/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.nativetool;

import java.io.File;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.tasks.nativetool.TaskHandlerNativeToolBase;
import org.jkiss.utils.CommonUtils;

public abstract class TaskHandlerNativeToolExport<BASE_OBJECT extends DBSObject, PROCESS_ARG>
extends TaskHandlerNativeToolBase<BASE_OBJECT, PROCESS_ARG> {
    protected File outputFolder;
    protected String outputFilePattern;

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public String getOutputFilePattern() {
        return this.outputFilePattern;
    }

    @Override
    protected boolean prepareTaskRun(DBRProgressMonitor monitor, DBTTask task, Log log) {
        if (this.outputFolder != null && !this.outputFolder.exists() && !this.outputFolder.mkdirs()) {
            log.error((Object)("Can't create directory '" + this.outputFolder.getAbsolutePath() + "'"));
            return false;
        }
        return true;
    }

    @Override
    protected void loadToolSettings(@NotNull DBRProgressMonitor monitor, @NotNull DBTTask task, Log log) {
        super.loadToolSettings(monitor, task, log);
        String outputFolderName = CommonUtils.toString(task.getProperties().get("outputFolder"));
        if (!CommonUtils.isEmpty((String)outputFolderName)) {
            this.outputFolder = new File(outputFolderName);
        }
        this.outputFilePattern = CommonUtils.toString(task.getProperties().get("outputFilePattern"));
    }
}

