/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.AggregateMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UserType;
import com.dbeaver.ee.cassandra.model.CasAggregate;
import com.dbeaver.ee.cassandra.model.CasCQLObject;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasFunction;
import com.dbeaver.ee.cassandra.model.CasMView;
import com.dbeaver.ee.cassandra.model.CasTable;
import com.dbeaver.ee.cassandra.model.CasUserType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class CasKeyspace
implements DBSCatalog,
CasCQLObject,
DBPSystemObject,
DBPRefreshableObject {
    private final CasDataSource dataSource;
    private final KeyspaceMetadata metadata;
    private final TableCache tableCache = new TableCache();
    private final MaterializedViewCache mviewsCache = new MaterializedViewCache();
    private final UserTypeCache userTypeCache = new UserTypeCache();
    private final AggregateCache aggregateCache = new AggregateCache();
    private final FunctionCache functionCache = new FunctionCache();

    public CasKeyspace(CasDataSource dataSource, KeyspaceMetadata metadata) {
        this.dataSource = dataSource;
        this.metadata = metadata;
    }

    @NotNull
    public CasDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.metadata.getName();
    }

    @Property
    public boolean isDurableWrites() {
        return this.metadata.isDurableWrites();
    }

    @Property
    public Map<String, String> getReplicationStrategy() {
        return this.metadata.getReplication();
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return true;
    }

    @Association
    public Collection<CasTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<CasMView> getMaterializedViews(DBRProgressMonitor monitor) throws DBException {
        return this.mviewsCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<CasUserType> getUserTypes(DBRProgressMonitor monitor) throws DBException {
        return this.userTypeCache.getAllObjects(monitor, this);
    }

    public CasUserType getUserType(DBRProgressMonitor monitor, DataType type) throws DBException {
        for (CasUserType userType : this.userTypeCache.getAllObjects(monitor, this)) {
            if (!userType.getCasDataType().equals(type)) continue;
            return userType;
        }
        return null;
    }

    @Association
    public Collection<CasAggregate> getAggregates(DBRProgressMonitor monitor) throws DBException {
        return this.aggregateCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<CasFunction> getFunctions(DBRProgressMonitor monitor) throws DBException {
        return this.functionCache.getAllObjects(monitor, this);
    }

    public Collection<CasTable> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getAllObjects(monitor, this);
    }

    public CasTable getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.tableCache.getObject(monitor, this, childName);
    }

    public Class<CasTable> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return CasTable.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.tableCache.getAllObjects(monitor, this);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) {
        return this.metadata.exportAsString();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableCache.clearCache();
        this.mviewsCache.clearCache();
        this.userTypeCache.clearCache();
        this.aggregateCache.clearCache();
        this.functionCache.clearCache();
        return this;
    }

    public boolean isSystem() {
        String name = this.getName();
        return name.equals("system") || name.startsWith("system_");
    }

    class AggregateCache
    extends AbstractObjectCache<CasKeyspace, CasAggregate> {
        AggregateCache() {
        }

        @NotNull
        public Collection<CasAggregate> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasAggregate> types = new ArrayList<CasAggregate>();
                for (AggregateMetadata tmd : CasKeyspace.this.metadata.getAggregates()) {
                    types.add(new CasAggregate(casKeyspace, tmd));
                    if (monitor.isCanceled()) break;
                }
                this.setCache(types);
            }
            return this.getCachedObjects();
        }

        public CasAggregate getObject(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace, @NotNull String name) throws DBException {
            return (CasAggregate)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }

    class FunctionCache
    extends AbstractObjectCache<CasKeyspace, CasFunction> {
        FunctionCache() {
        }

        @NotNull
        public Collection<CasFunction> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasFunction> types = new ArrayList<CasFunction>();
                for (FunctionMetadata tmd : CasKeyspace.this.metadata.getFunctions()) {
                    types.add(new CasFunction(casKeyspace, tmd));
                    if (monitor.isCanceled()) break;
                }
                this.setCache(types);
            }
            return this.getCachedObjects();
        }

        public CasFunction getObject(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace, @NotNull String name) throws DBException {
            return (CasFunction)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }

    class MaterializedViewCache
    extends AbstractObjectCache<CasKeyspace, CasMView> {
        MaterializedViewCache() {
        }

        @NotNull
        public Collection<CasMView> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasMView> tables = new ArrayList<CasMView>();
                for (MaterializedViewMetadata tmd : CasKeyspace.this.metadata.getMaterializedViews()) {
                    tables.add(new CasMView(casKeyspace, tmd));
                    if (monitor.isCanceled()) break;
                }
                this.setCache(tables);
            }
            return this.getCachedObjects();
        }

        public CasMView getObject(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace, @NotNull String name) throws DBException {
            return (CasMView)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }

    class TableCache
    extends AbstractObjectCache<CasKeyspace, CasTable> {
        TableCache() {
        }

        @NotNull
        public Collection<CasTable> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasTable> tables = new ArrayList<CasTable>();
                for (TableMetadata tmd : CasKeyspace.this.metadata.getTables()) {
                    tables.add(new CasTable(casKeyspace, tmd));
                    if (monitor.isCanceled()) break;
                }
                Collections.sort(tables, DBUtils.nameComparator());
                this.setCache(tables);
            }
            return this.getCachedObjects();
        }

        public CasTable getObject(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace, @NotNull String name) throws DBException {
            return (CasTable)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }

    class UserTypeCache
    extends AbstractObjectCache<CasKeyspace, CasUserType> {
        UserTypeCache() {
        }

        @NotNull
        public Collection<CasUserType> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasUserType> types = new ArrayList<CasUserType>();
                for (UserType tmd : CasKeyspace.this.metadata.getUserTypes()) {
                    types.add(new CasUserType(casKeyspace, tmd));
                    if (monitor.isCanceled()) break;
                }
                this.setCache(types);
            }
            return this.getCachedObjects();
        }

        public CasUserType getObject(@NotNull DBRProgressMonitor monitor, @Nullable CasKeyspace casKeyspace, @NotNull String name) throws DBException {
            return (CasUserType)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }
}

