/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.net;

import com.github.markusbernhardt.proxy.ProxySearch;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.runtime.net.GlobalProxySelector;
import org.jkiss.utils.CommonUtils;

public class DynamicProxySelector
extends GlobalProxySelector {
    private static final Log log = Log.getLog(DynamicProxySelector.class);
    private static final ProxySearch DEFAULT_PROXY_SEARCH = new ProxySearch();
    private volatile boolean isSearching = false;

    static {
        DEFAULT_PROXY_SEARCH.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
        DEFAULT_PROXY_SEARCH.addStrategy(ProxySearch.Strategy.BROWSER);
        DEFAULT_PROXY_SEARCH.addStrategy(ProxySearch.Strategy.ENV_VAR);
        DEFAULT_PROXY_SEARCH.addStrategy(ProxySearch.Strategy.JAVA);
    }

    public DynamicProxySelector(ProxySelector parent) {
        super(parent);
    }

    public List<Proxy> select(URI uri) {
        List<Proxy> proxies;
        if (!this.canHandleURI(uri)) {
            return super.select(uri);
        }
        if (!this.isSearching) {
            this.isSearching = true;
            try {
                DBPDataSourceContainer activeContext = this.getActiveDataSourceContainer(uri);
                if (activeContext != null) {
                    DBWHandlerConfiguration proxyConfig = activeContext.getActualConnectionConfiguration().getHandler("dynamic_proxy");
                    if (proxyConfig != null && proxyConfig.isEnabled() && proxyConfig.getBooleanProperty("pac_enabled")) {
                        ProxySearch proxySearch = this.getProxySearcher(uri, proxyConfig);
                        ProxySelector polySelector = proxySearch.getProxySelector();
                        if (polySelector != null) {
                            List<Proxy> list = polySelector.select(uri);
                            return list;
                        }
                        List proxies2 = super.getProxiesForDataSource(uri, activeContext);
                        if (proxies2 != null) {
                            List list = proxies2;
                            return list;
                        }
                    }
                    List<Proxy> list = this.getParent().select(uri);
                    return list;
                }
            }
            catch (Throwable e) {
                log.debug((Object)"Error selecting dynamic proxy", e);
            }
            finally {
                this.isSearching = false;
            }
        }
        if (CommonUtils.isEmpty(proxies = this.getParent().select(uri)) || proxies.size() == 1 && proxies.get(0) == Proxy.NO_PROXY && !this.isSearching) {
            try {
                try {
                    this.isSearching = true;
                    ProxySearch defProxySearcher = this.getDefaultProxySearcher();
                    ProxySelector polySelector = defProxySearcher.getProxySelector();
                    if (polySelector != null) {
                        proxies = polySelector.select(uri);
                    }
                }
                catch (Throwable e) {
                    log.debug((Object)"Default PAC error", e);
                    this.isSearching = false;
                }
            }
            finally {
                this.isSearching = false;
            }
        }
        return proxies;
    }

    private boolean canHandleURI(URI uri) {
        String host = uri.getHost();
        return !"localhost".equals(host) && !"127.0.0.1".equals(host);
    }

    @NotNull
    private ProxySearch getProxySearcher(URI uri, DBWHandlerConfiguration proxyConfig) {
        ProxySearch proxySearch = new ProxySearch();
        if (proxyConfig.getBooleanProperty("pac_strategy_os")) {
            proxySearch.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
        }
        if (proxyConfig.getBooleanProperty("pac_strategy_browser")) {
            proxySearch.addStrategy(ProxySearch.Strategy.BROWSER);
        }
        if (proxyConfig.getBooleanProperty("pac_strategy_env")) {
            proxySearch.addStrategy(ProxySearch.Strategy.ENV_VAR);
        }
        proxySearch.addStrategy(ProxySearch.Strategy.JAVA);
        return proxySearch;
    }

    @NotNull
    private ProxySearch getDefaultProxySearcher() {
        return DEFAULT_PROXY_SEARCH;
    }
}

