/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.mockdata.generator;

import com.dbeaver.ui.mockdata.generator.AbstractMockValueGenerator;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;

public class DateSequenceGenerator
extends AbstractMockValueGenerator {
    private static final Log log = Log.getLog(DateSequenceGenerator.class);
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy");
    public static final long DAY_RANGE = 86400000L;
    private long startDate = Long.MAX_VALUE;
    private boolean reverse = false;
    private long step = 86400000L;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<Object, Object> properties) throws DBException {
        Boolean reverse;
        Integer step;
        super.init(container, attribute, properties);
        String fromDate = (String)properties.get("startDate");
        if (fromDate != null) {
            try {
                this.startDate = DATE_FORMAT.parse(fromDate).getTime();
            }
            catch (ParseException e) {
                log.error((Object)("Error parse Start Date '" + fromDate + "'."), (Throwable)e);
            }
        }
        if (this.startDate == Long.MAX_VALUE) {
            this.startDate = new Date().getTime();
        }
        if ((step = (Integer)properties.get("step")) != null) {
            this.step = (long)step.intValue() * 86400000L;
        }
        if ((reverse = (Boolean)properties.get("reverse")) != null) {
            this.reverse = reverse;
        }
    }

    @Override
    public Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.isGenerateNULL()) {
            return null;
        }
        long value = this.startDate;
        this.startDate = this.reverse ? (this.startDate -= this.step) : (this.startDate += this.step);
        return new Date(value);
    }
}

