/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.nio.ByteBuffer;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
final class NIOMarkerPacket
extends NIOPacket {
    private boolean isReset;
    private boolean isBreak;
    private ByteBuffer markerBuffer;

    NIOMarkerPacket(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.header.type = 12;
        this.markerBuffer = ByteBuffer.allocate(11);
    }

    NIOMarkerPacket(NIOHeader nIOHeader, SessionAtts sessionAtts) throws IOException {
        super(nIOHeader, sessionAtts);
        nIOHeader.type = 12;
    }

    void writeToSocketChannel(int n2, byte by) throws IOException {
        this.markerBuffer.clear();
        if (this.session.isLargeSDU) {
            this.markerBuffer.putInt(this.markerBuffer.capacity());
        } else {
            this.markerBuffer.putShort((short)this.markerBuffer.capacity());
            this.markerBuffer.putShort((short)0);
        }
        this.markerBuffer.put((byte)this.header.type);
        this.markerBuffer.put((byte)this.header.flags);
        this.markerBuffer.putShort((short)0);
        this.markerBuffer.put((byte)n2);
        this.markerBuffer.put((byte)0);
        this.markerBuffer.put(by);
        this.markerBuffer.limit(this.markerBuffer.position());
        this.markerBuffer.rewind();
        if (this.session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            ((MQLNTAdapter)this.session.nt).writeToRemoteQueue(this.markerBuffer, false);
        } else {
            while (this.markerBuffer.hasRemaining()) {
                this.session.socketChannel.write(this.markerBuffer);
            }
        }
    }

    @Override
    void readPayloadBuffer() throws IOException {
        byte by = this.session.payloadBuffer.get();
        byte by2 = this.session.payloadBuffer.get();
        switch (by) {
            case 0: {
                this.isBreak = true;
                break;
            }
            case 1: {
                byte by3 = this.session.payloadBuffer.get();
                if (by3 == 2) {
                    this.isBreak = false;
                    this.isReset = true;
                    break;
                }
                this.isReset = false;
                this.isBreak = true;
                break;
            }
            default: {
                throw new NetException(205);
            }
        }
    }

    boolean isBreakPkt() {
        return this.isBreak;
    }

    boolean isResetPkt() {
        return this.isReset;
    }
}

