/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cachedb.database;

import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;

public class CacheDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "cache";

    public CacheDatabase() {
        super.setCurrentDateTimeFunction("SYSDATE");
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:Cache")) {
            return "com.intersys.jdbc.CacheDriver";
        }
        return null;
    }

    protected String getDefaultDatabaseProductName() {
        return "Cache";
    }

    public Integer getDefaultPort() {
        return 1972;
    }

    public int getPriority() {
        return 1;
    }

    public String getShortName() {
        return PRODUCT_NAME;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public String getLineComment() {
        return "--";
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public boolean supportsAutoIncrement() {
        return false;
    }

    public String getViewDefinition(CatalogAndSchema schema, String viewName) throws DatabaseException {
        return null;
    }
}

